/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.Converter;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.event.Event;

public class ExprSpawn
extends PropertyExpression<World, Location> {
    static {
        Skript.registerExpression(ExprSpawn.class, Location.class, ExpressionType.PROPERTY, "[the] spawn[s] [(point|location)[s]] [of %worlds%]", "%worlds%'[s] spawn[s] [(point|location)[s]]");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.setExpr(exprs[0]);
        return true;
    }

    protected Location[] get(Event e, World[] source) {
        return this.get(source, new Converter<World, Location>(){

            @Override
            public Location convert(World w) {
                return w.getSpawnLocation();
            }
        });
    }

    @Override
    public Class<? extends Location> getReturnType() {
        return Location.class;
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "spawn of " + this.getExpr().toString(e, debug);
    }

    @Override
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return Skript.array(Location.class);
        }
        return null;
    }

    @Override
    public void change(Event e, Object delta, Changer.ChangeMode mode) throws UnsupportedOperationException {
        Location l = (Location)delta;
        int x = l.getBlockX();
        int y = l.getBlockY();
        int z = l.getBlockZ();
        World[] worldArray = (World[])this.getExpr().getArray(e);
        int n = worldArray.length;
        int n2 = 0;
        while (n2 < n) {
            World w = worldArray[n2];
            w.setSpawnLocation(x, y, z);
            ++n2;
        }
    }
}

