/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.effects.Delay;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.lang.util.SimpleLiteral;
import ch.njol.util.Kleenean;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.event.Event;
import org.bukkit.event.block.SignChangeEvent;

public class ExprSignText
extends SimpleExpression<String> {
    private Expression<Number> line;
    private Expression<Block> block;

    static {
        Skript.registerExpression(ExprSignText.class, String.class, ExpressionType.PROPERTY, "[the] line %number% [of %block%]", "[the] (1\u00a61st|1\u00a6first|2\u00a62nd|2\u00a6second|3\u00a63rd|3\u00a6third|4\u00a64th|4\u00a6fourth) line [of %block%]");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.line = matchedPattern == 0 ? exprs[0] : new SimpleLiteral<Integer>(parseResult.mark, false);
        this.block = exprs[exprs.length - 1];
        return true;
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "line " + this.line.toString(e, debug) + " of " + this.block.toString(e, debug);
    }

    protected String[] get(Event e) {
        Number l = this.line.getSingle(e);
        if (l == null) {
            return null;
        }
        int line = l.intValue() - 1;
        if (line < 0 || line > 3) {
            return null;
        }
        if (this.getTime() >= 0 && this.block.isDefault() && e instanceof SignChangeEvent && !Delay.isDelayed(e)) {
            return new String[]{((SignChangeEvent)e).getLine(line)};
        }
        Block b = this.block.getSingle(e);
        if (b == null) {
            return null;
        }
        if (b.getType() != Material.SIGN_POST && b.getType() != Material.WALL_SIGN) {
            return null;
        }
        return new String[]{((Sign)b.getState()).getLine(line)};
    }

    @Override
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.CLEAR || mode == Changer.ChangeMode.SET) {
            return new Class[]{String.class};
        }
        return null;
    }

    @Override
    public void change(Event e, Object delta, Changer.ChangeMode mode) throws UnsupportedOperationException {
        Number l = this.line.getSingle(e);
        if (l == null) {
            return;
        }
        int line = l.intValue() - 1;
        if (line < 0 || line > 3) {
            return;
        }
        if (this.getTime() >= 0 && this.block.isDefault() && e instanceof SignChangeEvent && !Delay.isDelayed(e)) {
            switch (mode) {
                case CLEAR: {
                    ((SignChangeEvent)e).setLine(line, "");
                    break;
                }
                case SET: {
                    ((SignChangeEvent)e).setLine(line, (String)delta);
                }
            }
            return;
        }
        Block b = this.block.getSingle(e);
        if (b == null) {
            return;
        }
        if (b.getType() != Material.SIGN_POST && b.getType() != Material.WALL_SIGN) {
            return;
        }
        Sign s = (Sign)b.getState();
        switch (mode) {
            case CLEAR: {
                s.setLine(line, "");
                break;
            }
            case SET: {
                s.setLine(line, (String)delta);
            }
        }
        s.update();
    }

    @Override
    public boolean getAnd() {
        return true;
    }

    @Override
    public boolean setTime(int time) {
        return super.setTime(time, SignChangeEvent.class, this.block);
    }
}

