/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.Utils;
import ch.njol.util.Kleenean;
import java.lang.reflect.Array;
import org.bukkit.event.Event;

public class ExprRandom
extends SimpleExpression<Object> {
    private Expression<?> expr;

    static {
        Skript.registerExpression(ExprRandom.class, Object.class, ExpressionType.COMBINED, "[a] random <.+> [out] of %objects%");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        Class<?> c = Classes.getClassFromUserInput(parseResult.regexes.get(0).group());
        if (c == null) {
            return false;
        }
        this.expr = exprs[0];
        return c.isAssignableFrom(this.expr.getReturnType());
    }

    @Override
    protected Object[] get(Event e) {
        Object[] set = this.expr.getAll(e);
        if (set.length <= 1) {
            return set;
        }
        Object[] one = (Object[])Array.newInstance(set.getClass().getComponentType(), 1);
        one[0] = Utils.random(set);
        return one;
    }

    @Override
    public Class<? extends Object> getReturnType() {
        return this.expr.getReturnType();
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "a random element out of " + this.expr.toString(e, debug);
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public boolean getAnd() {
        return false;
    }
}

