/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Utils;
import ch.njol.util.Kleenean;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ExprName
extends SimplePropertyExpression<Object, String> {
    static final int PLAYER = 1;
    static final int ITEMSTACK = 2;
    private NameType type;

    static {
        NameType[] nameTypeArray = NameType.values();
        int n = nameTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            NameType n3 = nameTypeArray[n2];
            if (n3.getFrom() != null) {
                ExprName.register(ExprName.class, String.class, n3.pattern, n3.getFrom());
            }
            ++n2;
        }
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.type = NameType.values()[parseResult.mark];
        return super.init(exprs, matchedPattern, isDelayed, parseResult);
    }

    @Override
    public Class<String> getReturnType() {
        return String.class;
    }

    @Override
    protected String getPropertyName() {
        return this.type.name;
    }

    @Override
    public String convert(Object o) {
        return this.type.get(o);
    }

    @Override
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET && ((this.type.acceptChange & 1) == 1 && !ItemStack.class.isAssignableFrom(this.getExpr().getReturnType()) || (this.type.acceptChange & 2) == 2 && this.getExpr().isSingle() && Utils.contains(this.getExpr().acceptChange(Changer.ChangeMode.SET), ItemStack.class))) {
            return Skript.array(String.class);
        }
        return null;
    }

    @Override
    public void change(Event e, Object delta, Changer.ChangeMode mode) throws UnsupportedOperationException {
        if (ItemStack.class.isAssignableFrom(this.getExpr().getReturnType())) {
            ItemStack i = (ItemStack)this.getExpr().getSingle(e);
            this.type.set(i, (String)delta);
            this.getExpr().change(e, i, Changer.ChangeMode.SET);
        } else {
            F[] FArray = this.getExpr().getArray(e);
            int n = FArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = FArray[n2];
                if (o instanceof Player) {
                    this.type.set(o, (String)delta);
                }
                ++n2;
            }
        }
    }

    private static enum NameType {
        NAME("name", "name", 3, 2){

            @Override
            void set(Object o, String s) {
                ItemMeta m = ((ItemStack)o).getItemMeta();
                m.setDisplayName(s);
                ((ItemStack)o).setItemMeta(m);
            }

            @Override
            String get(Object o) {
                if (o instanceof Player) {
                    return ((Player)o).getName();
                }
                ItemMeta m = ((ItemStack)o).getItemMeta();
                return m.hasDisplayName() ? m.getDisplayName() : null;
            }
        }
        ,
        DISPLAY_NAME("display name", "(display|nick)[ ]name", 3, 3){

            @Override
            void set(Object o, String s) {
                if (o instanceof Player) {
                    ((Player)o).setDisplayName(String.valueOf(s) + ChatColor.RESET);
                } else {
                    ItemMeta m = ((ItemStack)o).getItemMeta();
                    m.setDisplayName(s);
                    ((ItemStack)o).setItemMeta(m);
                }
            }

            @Override
            String get(Object o) {
                if (o instanceof Player) {
                    return ((Player)o).getDisplayName();
                }
                ItemMeta m = ((ItemStack)o).getItemMeta();
                return m.hasDisplayName() ? m.getDisplayName() : null;
            }
        }
        ,
        TABLIST_NAME("player list name", "(player|tab)[ ]list name", 1, 1){

            @Override
            void set(Object o, String s) {
                ((Player)o).setPlayerListName(s.length() > 16 ? s.substring(0, 16) : s);
            }

            @Override
            String get(Object o) {
                return ((Player)o).getPlayerListName();
            }
        };

        final String name;
        final String pattern;
        final int from;
        final int acceptChange;

        private NameType(String name, String pattern, int from, int change) {
            this.name = name;
            this.pattern = "(" + this.ordinal() + "\u00a6)" + pattern;
            this.from = from;
            this.acceptChange = change;
        }

        abstract void set(Object var1, String var2);

        abstract String get(Object var1);

        String getFrom() {
            if (this.from == 2) {
                if (!Skript.isRunningMinecraft(1, 4, 5)) {
                    return null;
                }
                return "itemstacks";
            }
            if (this.from == 1 || !Skript.isRunningMinecraft(1, 4, 5)) {
                return "players";
            }
            return "players/itemstacks";
        }
    }
}

