/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Direction;
import ch.njol.util.Kleenean;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.material.Directional;
import org.bukkit.material.MaterialData;
import org.bukkit.util.Vector;

public class ExprFacing
extends SimplePropertyExpression<Object, Direction> {
    private boolean horizontal;

    static {
        ExprFacing.register(ExprFacing.class, Direction.class, "(1\u00a6horizontal|) facing", "livingentities/blocks");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        super.init(exprs, matchedPattern, isDelayed, parseResult);
        this.horizontal = parseResult.mark == 1;
        return true;
    }

    @Override
    public Direction convert(Object o) {
        if (o instanceof Block) {
            MaterialData d = ((Block)o).getType().getNewData(((Block)o).getData());
            if (d instanceof Directional) {
                return new Direction(((Directional)d).getFacing());
            }
            return null;
        }
        if (o instanceof LivingEntity) {
            return new Direction(Direction.getFacing(((LivingEntity)o).getLocation(), this.horizontal));
        }
        assert (false);
        return null;
    }

    @Override
    protected String getPropertyName() {
        return String.valueOf(this.horizontal ? "horizontal " : "") + "facing";
    }

    @Override
    public Class<Direction> getReturnType() {
        return Direction.class;
    }

    @Override
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (!Block.class.isAssignableFrom(this.getExpr().getReturnType())) {
            return null;
        }
        if (mode == Changer.ChangeMode.SET) {
            return Skript.array(Direction.class);
        }
        return null;
    }

    @Override
    public void change(Event e, Object delta, Changer.ChangeMode mode) throws UnsupportedOperationException {
        Block b = (Block)this.getExpr().getSingle(e);
        if (b == null) {
            return;
        }
        MaterialData d = b.getType().getNewData(b.getData());
        if (!(d instanceof Directional)) {
            return;
        }
        ((Directional)d).setFacingDirection(ExprFacing.toBlockFace(((Direction)delta).getDirection(b)));
        b.setData(d.getData());
    }

    private static final BlockFace toBlockFace(Vector dir) {
        BlockFace r = null;
        double d = Double.MAX_VALUE;
        BlockFace[] blockFaceArray = BlockFace.values();
        int n = blockFaceArray.length;
        int n2 = 0;
        while (n2 < n) {
            BlockFace f = blockFaceArray[n2];
            double a = Math.pow((double)f.getModX() - dir.getX(), 2.0) + Math.pow((double)f.getModY() - dir.getY(), 2.0) + Math.pow((double)f.getModZ() - dir.getZ(), 2.0);
            if (a < d) {
                d = a;
                r = f;
            }
            ++n2;
        }
        assert (r != null);
        return r;
    }
}

