/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.Converter;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.Event;

public class ExprEnchantmentLevel
extends PropertyExpression<ItemType, Integer> {
    private Expression<Enchantment> enchantment;

    static {
        Skript.registerExpression(ExprEnchantmentLevel.class, Integer.class, ExpressionType.PROPERTY, "[the] (%-enchantment% level|level of %-enchantment%) o(f|n) %itemtypes%", "%itemtypes%'[s] (%-enchantment% level|level of %-enchantment%)");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.setExpr(exprs[2 - 2 * matchedPattern]);
        this.enchantment = exprs[matchedPattern] == null ? exprs[matchedPattern + 1] : exprs[matchedPattern];
        return true;
    }

    protected Integer[] get(Event e, ItemType[] source) {
        final Enchantment ench = this.enchantment.getSingle(e);
        if (ench == null) {
            return null;
        }
        return this.get(source, new Converter<ItemType, Integer>(){

            @Override
            public Integer convert(ItemType i) {
                if (i.getEnchantments() == null) {
                    return 0;
                }
                Integer l = i.getEnchantments().get(ench);
                return l == null ? Integer.valueOf(0) : l;
            }
        });
    }

    @Override
    public Class<? extends Integer> getReturnType() {
        return Integer.class;
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "the level of " + this.enchantment.toString(e, debug) + " of " + this.getExpr().toString(e, debug);
    }
}

