/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.util.Color;
import ch.njol.skript.util.Utils;
import org.bukkit.Material;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

public class ExprColorOf
extends SimplePropertyExpression<ItemStack, Color> {
    static {
        ExprColorOf.register(ExprColorOf.class, Color.class, "colo[u]r[s]", "itemstacks");
    }

    @Override
    public Color convert(ItemStack is) {
        if (is.getType() == Material.WOOL) {
            return Color.byWool(is.getDurability());
        }
        if (is.getType() == Material.INK_SACK) {
            return Color.byDye(is.getDurability());
        }
        return null;
    }

    @Override
    protected String getPropertyName() {
        return "color";
    }

    @Override
    public Class<Color> getReturnType() {
        return Color.class;
    }

    @Override
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode != Changer.ChangeMode.SET || !this.getExpr().isSingle()) {
            return null;
        }
        if (this.getExpr().acceptChange(mode) != null && Utils.containsAny(this.getExpr().acceptChange(mode), ItemStack.class, ItemType.class)) {
            return Skript.array(Color.class);
        }
        return null;
    }

    @Override
    public void change(Event e, Object delta, Changer.ChangeMode mode) throws UnsupportedOperationException {
        ItemStack is = (ItemStack)this.getExpr().getSingle(e);
        if (is == null) {
            return;
        }
        if (is.getType() == Material.WOOL) {
            is.setDurability((short)((Color)((Object)delta)).getWool());
        } else if (is.getType() == Material.INK_SACK) {
            is.setDurability((short)((Color)((Object)delta)).getDye());
        } else {
            return;
        }
        if (Utils.contains(this.getExpr().acceptChange(mode), ItemStack.class)) {
            this.getExpr().change(e, is, mode);
        } else {
            this.getExpr().change(e, new ItemType(is), mode);
        }
    }
}

