/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.BlockLineIterator;
import ch.njol.skript.util.Direction;
import ch.njol.util.Kleenean;
import ch.njol.util.iterator.ArrayIterator;
import ch.njol.util.iterator.IteratorIterable;
import java.util.ArrayList;
import java.util.Iterator;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.event.Event;

public class ExprBlocks
extends SimpleExpression<Block> {
    private Expression<?> from;
    private Expression<Block> end;
    private Expression<Direction> direction;

    static {
        Skript.registerExpression(ExprBlocks.class, Block.class, ExpressionType.NORMAL, "[the] blocks %direction% [%locations%]", "[the] blocks from %location% [on] %direction%", "[the] blocks from %block% to %block%", "[the] blocks between %block% and %block%");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        switch (matchedPattern) {
            case 0: {
                this.direction = exprs[0];
                this.from = exprs[1];
                break;
            }
            case 1: {
                this.from = exprs[1];
                this.direction = exprs[1];
                break;
            }
            case 2: 
            case 3: {
                this.from = exprs[1];
                this.end = exprs[1];
            }
        }
        return true;
    }

    @Override
    public String toString(Event e, boolean debug) {
        if (this.end == null) {
            return "block" + (this.isSingle() ? "" : "s") + " " + this.direction.toString(e, debug) + " " + this.from.toString(e, debug);
        }
        return "blocks from " + this.from.toString(e, debug) + " to " + this.end.toString(e, debug);
    }

    protected Block[] get(Event e) {
        if (!this.from.isSingle()) {
            Location[] ls = (Location[])this.from.getArray(e);
            Direction d = this.direction.getSingle(e);
            if (ls.length == 0 || d == null) {
                return null;
            }
            Block[] bs = new Block[ls.length];
            int i = 0;
            while (i < ls.length) {
                bs[i] = d.getRelative(ls[i]).getBlock();
                ++i;
            }
            return bs;
        }
        ArrayList<Block> r = new ArrayList<Block>();
        for (Block b : new IteratorIterable<Block>(this.iterator(e))) {
            r.add(b);
        }
        return r.toArray(new Block[r.size()]);
    }

    @Override
    public Iterator<Block> iterator(Event e) {
        if (this.direction != null) {
            if (!this.from.isSingle()) {
                return new ArrayIterator<Block>(this.get(e));
            }
            Object o = this.from.getSingle(e);
            if (o == null) {
                return null;
            }
            Location l = o instanceof Location ? (Location)o : ((Block)o).getLocation().add(0.5, 0.5, 0.5);
            Direction d = this.direction.getSingle(e);
            if (d == null) {
                return null;
            }
            return new BlockLineIterator(l, o != l ? d.getDirection((Block)o) : d.getDirection(l), 100.0);
        }
        Block b = (Block)this.from.getSingle(e);
        if (b == null) {
            return null;
        }
        Block b2 = this.end.getSingle(e);
        if (b2 == null || b2.getWorld() != b.getWorld()) {
            return null;
        }
        return new BlockLineIterator(b, b2);
    }

    @Override
    public Class<? extends Block> getReturnType() {
        return Block.class;
    }

    @Override
    public boolean isSingle() {
        return false;
    }

    @Override
    public boolean getAnd() {
        return true;
    }
}

