/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

public class ExprArmorSlot
extends SimplePropertyExpression<Player, ItemStack> {
    private int slot;
    private static final String[] slotNames;

    static {
        ExprArmorSlot.register(ExprArmorSlot.class, ItemStack.class, "(0\u00a6boot[s]|0\u00a6shoe[s]|1\u00a6leg[ging][s]|2\u00a6chestplate[s]|3\u00a6helm[et][s]) [slot]", "players");
        slotNames = new String[]{"boots", "leggings", "chestplate", "helmet"};
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        super.init(exprs, matchedPattern, isDelayed, parseResult);
        this.slot = parseResult.mark;
        return true;
    }

    @Override
    public ItemStack convert(Player p) {
        return p.getInventory().getArmorContents()[this.slot];
    }

    @Override
    protected String getPropertyName() {
        return slotNames[this.slot];
    }

    @Override
    public Class<ItemStack> getReturnType() {
        return ItemStack.class;
    }

    @Override
    public Class<ItemStack>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return Skript.array(ItemStack.class);
        }
        return null;
    }

    @Override
    public void change(Event e, Object delta, Changer.ChangeMode mode) {
        Player[] playerArray = (Player[])this.getExpr().getArray(e);
        int n = playerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Player p = playerArray[n2];
            ItemStack[] armour = p.getInventory().getArmorContents();
            armour[this.slot] = (ItemStack)delta;
            p.getInventory().setArmorContents(armour);
            ++n2;
        }
    }
}

