/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.Patterns;
import ch.njol.util.Kleenean;
import java.lang.reflect.Array;
import org.bukkit.event.Event;

public class ExprArithmetic
extends SimpleExpression<Number> {
    private static final Patterns<Operator> patterns;
    private Expression<? extends Number> first;
    private Expression<? extends Number> second;
    private Operator op;
    private Class<? extends Number> returnType;
    private boolean integer;

    static {
        Object[][] objectArray = new Object[6][];
        objectArray[0] = new Object[]{"%number%[ ]+[ ]%number%", Operator.PLUS};
        objectArray[1] = new Object[]{"%number%[ ]-[ ]%number%", Operator.MINUS};
        objectArray[2] = new Object[]{"%number%[ ]*[ ]%number%", Operator.MULT};
        objectArray[3] = new Object[]{"%number%[ ]/[ ]%number%", Operator.DIV};
        objectArray[4] = new Object[]{"%number%[ ]^[ ]%number%", Operator.EXP};
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "\\(%number%\\)";
        objectArray[5] = objectArray2;
        patterns = new Patterns(objectArray);
        Skript.registerExpression(ExprArithmetic.class, Number.class, ExpressionType.PATTERN_MATCHES_EVERYTHING, patterns.getPatterns());
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.first = exprs[0];
        this.second = exprs.length == 1 ? null : exprs[1];
        this.op = patterns.getInfo(matchedPattern);
        if (this.op == null) {
            this.returnType = this.first.getReturnType();
        } else if (this.op == Operator.DIV || this.op == Operator.EXP) {
            this.returnType = Double.class;
        } else {
            Class<? extends Number> f = this.first.getReturnType();
            Class<? extends Number> s = this.second.getReturnType();
            Class[] integers = new Class[]{Long.class, Integer.class, Short.class, Byte.class};
            boolean firstIsInt = false;
            boolean secondIsInt = false;
            Class[] classArray = integers;
            int n = integers.length;
            int n2 = 0;
            while (n2 < n) {
                Class i = classArray[n2];
                firstIsInt |= i.isAssignableFrom(f);
                secondIsInt |= i.isAssignableFrom(s);
                ++n2;
            }
            this.returnType = firstIsInt && secondIsInt ? Integer.class : Double.class;
        }
        this.integer = this.returnType == Integer.class;
        return true;
    }

    protected Number[] get(Event e) {
        if (this.op == null) {
            return this.first.getArray(e);
        }
        Number[] one = (Number[])Array.newInstance(this.returnType, 1);
        Number n1 = this.first.getSingle(e);
        Number n2 = this.second.getSingle(e);
        if (n1 == null) {
            n1 = 0;
        }
        if (n2 == null) {
            n2 = 0;
        }
        one[0] = this.op.calculate(n1, n2, this.integer);
        return one;
    }

    @Override
    public Class<? extends Number> getReturnType() {
        return this.returnType;
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public boolean getAnd() {
        return true;
    }

    @Override
    public String toString(Event e, boolean debug) {
        if (this.op == null) {
            return "(" + this.first.toString(e, debug) + ")";
        }
        return String.valueOf(this.first.toString(e, debug)) + " " + (Object)((Object)this.op) + " " + this.second.toString(e, debug);
    }

    @Override
    public Expression<? extends Number> simplify() {
        if (this.op == null) {
            return this.first;
        }
        return this;
    }

    private static enum Operator {
        PLUS('+'){

            @Override
            public Number calculate(Number n1, Number n2, boolean integer) {
                if (integer) {
                    return n1.intValue() + n2.intValue();
                }
                return n1.doubleValue() + n2.doubleValue();
            }
        }
        ,
        MINUS('-'){

            @Override
            public Number calculate(Number n1, Number n2, boolean integer) {
                if (integer) {
                    return n1.intValue() - n2.intValue();
                }
                return n1.doubleValue() - n2.doubleValue();
            }
        }
        ,
        MULT('*'){

            @Override
            public Number calculate(Number n1, Number n2, boolean integer) {
                if (integer) {
                    return n1.intValue() * n2.intValue();
                }
                return n1.doubleValue() * n2.doubleValue();
            }
        }
        ,
        DIV('/'){

            @Override
            public Number calculate(Number n1, Number n2, boolean integer) {
                if (integer) {
                    return n1.intValue() / n2.intValue();
                }
                return n1.doubleValue() / n2.doubleValue();
            }
        }
        ,
        EXP('^'){

            @Override
            public Number calculate(Number n1, Number n2, boolean integer) {
                if (integer) {
                    return (int)Math.pow(n1.intValue(), n2.intValue());
                }
                return Math.pow(n1.doubleValue(), n2.doubleValue());
            }
        };

        public final char sign;

        private Operator(char sign) {
            this.sign = sign;
        }

        public abstract Number calculate(Number var1, Number var2, boolean var3);

        public String toString() {
            return "" + this.sign;
        }
    }
}

