/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.events;

import ch.njol.skript.Skript;
import ch.njol.skript.events.SkriptStartEvent;
import ch.njol.skript.events.SkriptStopEvent;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SelfRegisteringSkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Trigger;
import java.util.ArrayList;
import java.util.Collection;
import org.bukkit.event.Event;

public class EvtSkript
extends SelfRegisteringSkriptEvent {
    private boolean isStart;
    private static final Collection<Trigger> start;
    private static final Collection<Trigger> stop;

    static {
        Skript.registerEvent(EvtSkript.class, Skript.array(SkriptStartEvent.class, SkriptStopEvent.class), "(server|skript) (start|load)", "(server|skript) stop");
        start = new ArrayList<Trigger>();
        stop = new ArrayList<Trigger>();
    }

    @Override
    public boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parser) {
        this.isStart = matchedPattern == 0;
        return true;
    }

    public static void onSkriptStart() {
        SkriptStartEvent e = new SkriptStartEvent();
        for (Trigger t : start) {
            t.execute(e);
        }
    }

    public static void onSkriptStop() {
        SkriptStopEvent e = new SkriptStopEvent();
        for (Trigger t : stop) {
            t.execute(e);
        }
    }

    @Override
    public void register(Trigger t) {
        if (this.isStart) {
            start.add(t);
        } else {
            stop.add(t);
        }
    }

    @Override
    public void unregister(Trigger t) {
        if (this.isStart) {
            start.remove(t);
        } else {
            stop.remove(t);
        }
    }

    @Override
    public void unregisterAll() {
        start.clear();
        stop.clear();
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "on server " + (this.isStart ? "start" : "stop");
    }
}

