/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.events;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptEventHandler;
import ch.njol.skript.aliases.ItemData;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SelfRegisteringSkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.registrations.Classes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.event.Event;
import org.bukkit.event.EventException;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.EventExecutor;
import org.bukkit.plugin.Plugin;

public class EvtMoveOn
extends SelfRegisteringSkriptEvent {
    private static final HashMap<Integer, List<Trigger>> itemTypeTriggers;
    private ItemType[] types = null;
    private static boolean registeredExecutor;
    private static final EventExecutor executor;

    static {
        Skript.registerEvent(EvtMoveOn.class, PlayerMoveEvent.class, "(step|walk)[ing] (on|over) %itemtypes%");
        itemTypeTriggers = new HashMap();
        registeredExecutor = false;
        executor = new EventExecutor(){

            public void execute(Listener l, Event event) throws EventException {
                PlayerMoveEvent e = (PlayerMoveEvent)event;
                Location from = e.getFrom();
                Location to = e.getTo();
                if (from.getWorld() == to.getWorld() && from.getBlockX() == to.getBlockX() && from.getBlockY() == to.getBlockY() && from.getBlockZ() == to.getBlockZ()) {
                    return;
                }
                SkriptEventHandler.logEventStart((Event)e);
                if (!itemTypeTriggers.isEmpty()) {
                    int id = to.getWorld().getBlockTypeIdAt(to.getBlockX(), to.getBlockY(), to.getBlockZ());
                    List ts = (List)itemTypeTriggers.get(id);
                    if (ts != null) {
                        byte data = to.getBlock().getData();
                        block0: for (Trigger t : ts) {
                            EvtMoveOn se = (EvtMoveOn)t.getEvent();
                            ItemType[] itemTypeArray = se.types;
                            int n = itemTypeArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                ItemType i = itemTypeArray[n2];
                                if (i.isOfType(id, data)) {
                                    SkriptEventHandler.logTriggerStart(t);
                                    t.execute((Event)e);
                                    SkriptEventHandler.logTriggerEnd(t);
                                    continue block0;
                                }
                                ++n2;
                            }
                        }
                    }
                }
                SkriptEventHandler.logEventEnd();
            }
        };
    }

    @Override
    public boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parser) {
        if (parser.regexes.get(0).group().equalsIgnoreCase("<block>")) {
            return true;
        }
        Literal<?> l = args[0];
        if (l == null) {
            return false;
        }
        ItemType[] itemTypeArray = this.types = (ItemType[])l.getAll();
        int n = this.types.length;
        int n2 = 0;
        while (n2 < n) {
            ItemType t = itemTypeArray[n2];
            boolean hasBlock = false;
            for (ItemData d : t) {
                if (d.getId() == -1) {
                    Skript.error("Can't use an 'on walk' event with an alias that matches all blocks");
                    return false;
                }
                if (d.getId() > 255) continue;
                hasBlock = true;
            }
            if (!hasBlock) {
                Skript.error(t + " is not a block and can thus not be walked on");
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "walk on " + Classes.toString(this.types, false);
    }

    @Override
    public void register(Trigger trigger) {
        ItemType[] itemTypeArray = this.types;
        int n = this.types.length;
        int n2 = 0;
        while (n2 < n) {
            ItemType t = itemTypeArray[n2];
            for (ItemData d : t) {
                if (d.getId() > 255) continue;
                List<Trigger> ts = itemTypeTriggers.get(d.getId());
                if (ts == null) {
                    ts = new ArrayList<Trigger>();
                    itemTypeTriggers.put(d.getId(), ts);
                }
                ts.add(trigger);
            }
            ++n2;
        }
        if (!registeredExecutor) {
            Bukkit.getPluginManager().registerEvent(PlayerMoveEvent.class, new Listener(){}, Skript.getDefaultEventPriority(), executor, (Plugin)Skript.getInstance(), true);
            registeredExecutor = true;
        }
    }

    @Override
    public void unregister(Trigger t) {
        Iterator<Map.Entry<Integer, List<Trigger>>> i2 = itemTypeTriggers.entrySet().iterator();
        while (i2.hasNext()) {
            List<Trigger> ts = i2.next().getValue();
            ts.remove(t);
            if (!ts.isEmpty()) continue;
            i2.remove();
        }
    }

    @Override
    public void unregisterAll() {
        itemTypeTriggers.clear();
    }
}

