/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.events;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptEventHandler;
import ch.njol.skript.events.util.PlayerChatEventHandler;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SelfRegisteringSkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.util.Task;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Callable;
import org.bukkit.event.Event;
import org.bukkit.event.EventException;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerChatEvent;
import org.bukkit.plugin.EventExecutor;

public class EvtChat
extends SelfRegisteringSkriptEvent {
    private static final Collection<Trigger> triggers;
    private static boolean registeredExecutor;
    private static final EventExecutor executor;

    static {
        if (Skript.isRunningMinecraft(1, 3)) {
            Skript.registerEvent(EvtChat.class, AsyncPlayerChatEvent.class, "chat");
        } else {
            Skript.registerEvent(EvtChat.class, PlayerChatEvent.class, "chat");
        }
        triggers = new ArrayList<Trigger>();
        registeredExecutor = false;
        executor = new EventExecutor(){

            private final void execute(Event e) {
                SkriptEventHandler.logEventStart(e);
                for (Trigger t : triggers) {
                    SkriptEventHandler.logTriggerStart(t);
                    t.execute(e);
                    SkriptEventHandler.logTriggerEnd(t);
                }
                SkriptEventHandler.logEventEnd();
            }

            public void execute(Listener l, final Event e) throws EventException {
                if (!triggers.isEmpty()) {
                    if (!Skript.isRunningMinecraft(1, 3) || !e.isAsynchronous()) {
                        this.execute(e);
                        return;
                    }
                    Task.callSync(new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            this.execute(e);
                            return null;
                        }
                    });
                }
            }
        };
    }

    @Override
    public boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parser) {
        return true;
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "chat";
    }

    @Override
    public void register(Trigger t) {
        triggers.add(t);
        if (!registeredExecutor) {
            PlayerChatEventHandler.registerChatEvent(Skript.getDefaultEventPriority(), executor, true);
            registeredExecutor = true;
        }
    }

    @Override
    public void unregister(Trigger t) {
        triggers.remove(t);
    }

    @Override
    public void unregisterAll() {
        triggers.clear();
    }
}

