/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.entity;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.registrations.Classes;
import ch.njol.util.StringUtils;
import org.bukkit.Location;
import org.bukkit.entity.ExperienceOrb;

public class XpOrbData
extends EntityData<ExperienceOrb> {
    private int xp = -1;
    private boolean plural;

    static {
        XpOrbData.register(XpOrbData.class, "xporb", ExperienceOrb.class, "<\\d+> ([e]xp|experience)", "([e]xp|experience)[( |-)orb[s]]");
        Classes.registerClass(new ClassInfo<XpOrbData>(XpOrbData.class, "experience").parser(new Parser<XpOrbData>(){

            @Override
            public XpOrbData parse(String s, ParseContext context) {
                int xp = -1;
                if (s.matches("\\d+ .+")) {
                    xp = Skript.parseInt(s.substring(0, s.indexOf(32)));
                    s = s.substring(s.indexOf(32) + 1);
                } else if (StringUtils.startsWithIgnoreCase(s, "a ") || StringUtils.startsWithIgnoreCase(s, "an ")) {
                    xp = 1;
                    s = s.substring(s.indexOf(32) + 1);
                }
                if (s.matches("(e?xp|experience)([ -]orbs?)?")) {
                    return new XpOrbData(xp);
                }
                return null;
            }

            @Override
            public String toString(XpOrbData xp) {
                return xp.toString();
            }

            @Override
            public String toVariableNameString(XpOrbData xp) {
                return xp.toString();
            }

            @Override
            public String getVariableNamePattern() {
                return ".+";
            }
        }).serializer(EntityData.serializer));
    }

    public XpOrbData() {
    }

    public XpOrbData(int xp) {
        this.xp = xp;
    }

    @Override
    protected boolean init(Literal<?>[] exprs, int matchedPattern, SkriptParser.ParseResult parseResult) {
        if (matchedPattern == 0) {
            this.xp = Skript.parseInt(parseResult.regexes.get(0).group());
        }
        this.plural = StringUtils.endsWithIgnoreCase(parseResult.expr, "s");
        return true;
    }

    @Override
    public void set(ExperienceOrb entity) {
        if (this.xp != -1) {
            entity.setExperience(this.xp);
        }
    }

    @Override
    protected boolean match(ExperienceOrb entity) {
        return this.xp == -1 || entity.getExperience() == this.xp;
    }

    @Override
    public Class<? extends ExperienceOrb> getType() {
        return ExperienceOrb.class;
    }

    @Override
    public String toString() {
        return "experience orb";
    }

    @Override
    public ExperienceOrb spawn(Location loc) {
        ExperienceOrb orb = (ExperienceOrb)super.spawn(loc);
        orb.setExperience(this.xp == -1 ? 1 : this.xp);
        return orb;
    }

    @Override
    public boolean isPlural() {
        return this.plural;
    }

    public int getExperience() {
        return this.xp == -1 ? 1 : this.xp;
    }

    public int getInternExperience() {
        return this.xp;
    }

    @Override
    public int hashCode() {
        return this.xp;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof XpOrbData)) {
            return false;
        }
        XpOrbData other = (XpOrbData)obj;
        return this.xp == other.xp;
    }

    @Override
    public String serialize() {
        return "" + this.xp;
    }

    @Override
    protected boolean deserialize(String s) {
        try {
            this.xp = Integer.parseInt(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    protected boolean isSupertypeOf_i(EntityData<? extends ExperienceOrb> e) {
        if (e instanceof XpOrbData) {
            return this.xp == -1 || ((XpOrbData)e).xp == this.xp;
        }
        return false;
    }
}

