/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Direction;
import ch.njol.util.Kleenean;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;

public class EffShoot
extends Effect {
    private static final Double DEFAULT_SPEED;
    private Expression<EntityData<?>> types;
    private Expression<LivingEntity> shooters;
    private Expression<Number> velocity;
    private Expression<Direction> direction;

    static {
        Skript.registerEffect(EffShoot.class, "shoot %entitydatas% [from %livingentity%] [(at|with) (speed|velocity) %-number%] [%-direction%]", "(make|let) %livingentity% shoot %entitydatas% [(at|with) (speed|velocity) %-number%] [%-direction%]");
        DEFAULT_SPEED = 5.0;
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.types = exprs[matchedPattern];
        this.shooters = exprs[1 - matchedPattern];
        this.velocity = exprs[2];
        this.direction = exprs[3];
        return true;
    }

    @Override
    protected void execute(Event e) {
        Direction dir;
        Double v;
        Number number = v = this.velocity == null ? (Number)DEFAULT_SPEED : (Number)this.velocity.getSingle(e);
        if (v == null) {
            return;
        }
        Direction direction = dir = this.direction == null ? Direction.IDENTITY : this.direction.getSingle(e);
        if (dir == null) {
            return;
        }
        LivingEntity[] livingEntityArray = this.shooters.getArray(e);
        int n = livingEntityArray.length;
        int n2 = 0;
        while (n2 < n) {
            LivingEntity shooter = livingEntityArray[n2];
            EntityData<?>[] entityDataArray = this.types.getArray(e);
            int n3 = entityDataArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Projectile projectile;
                EntityData<?> d = entityDataArray[n4];
                Vector vel = dir.getDirection((Entity)shooter).multiply(((Number)v).doubleValue());
                if (Fireball.class.isAssignableFrom(d.getType())) {
                    projectile = (Fireball)shooter.getWorld().spawn(shooter.getEyeLocation().add(vel.normalize().multiply(0.5)), d.getType());
                    projectile.setShooter(shooter);
                    projectile.setVelocity(vel);
                } else if (Projectile.class.isAssignableFrom(d.getType())) {
                    projectile = shooter.launchProjectile(d.getType());
                    EffShoot.set((Entity)projectile, d);
                    projectile.setVelocity(vel);
                } else {
                    Location loc = shooter.getLocation();
                    loc.setY(loc.getY() + shooter.getEyeHeight() / 2.0);
                    Object projectile2 = d.spawn(loc);
                    if (projectile2 != null) {
                        projectile2.setVelocity(vel);
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }

    private static final <E extends Entity> void set(Entity e, EntityData<E> d) {
        d.set(e);
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "shoot " + this.types.toString(e, debug) + " from " + this.shooters.toString(e, debug) + (this.velocity == null ? "" : " at speed " + this.velocity.toString(e, debug)) + (this.direction == null ? "" : " " + this.direction.toString(e, debug));
    }
}

