/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptConfig;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.ExceptionUtils;
import ch.njol.util.Kleenean;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;

public class EffLog
extends Effect {
    private static final File logsFolder;
    private static final HashMap<String, PrintWriter> writers;
    private Expression<String> messages;
    private Expression<String> files;

    static {
        Skript.registerEffect(EffLog.class, "log %strings% [(to|in) [file[s]] %-strings%]");
        logsFolder = new File(Skript.getInstance().getDataFolder(), "logs");
        writers = new HashMap();
        Skript.closeOnDisable(new Closeable(){

            @Override
            public void close() throws IOException {
                for (PrintWriter pw : writers.values()) {
                    pw.close();
                }
            }
        });
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.messages = exprs[0];
        this.files = exprs[1];
        return true;
    }

    @Override
    protected void execute(Event e) {
        String[] stringArray = this.messages.getArray(e);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String message = stringArray[n2];
            if (this.files == null) {
                Skript.info("[" + this.getTrigger().getScript().getName() + "] " + message);
            } else {
                String[] stringArray2 = this.files.getArray(e);
                int n3 = stringArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    String s = stringArray2[n4];
                    if (!(s = s.toLowerCase()).endsWith(".log")) {
                        s = String.valueOf(s) + ".log";
                    }
                    if (s.equals("server.log")) {
                        Bukkit.getLogger().log(Level.INFO, message);
                    } else {
                        PrintWriter w = writers.get(s);
                        if (w == null) {
                            try {
                                logsFolder.mkdirs();
                                w = new PrintWriter(new BufferedWriter(new FileWriter(new File(logsFolder, s), true)));
                                writers.put(s, w);
                            }
                            catch (IOException ex) {
                                Skript.error("Cannot write to log file '" + s + "': " + ExceptionUtils.toString(ex));
                                return;
                            }
                        }
                        w.println("[" + SkriptConfig.getDateFormat().format(System.currentTimeMillis()) + "] " + message);
                        w.flush();
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "log " + this.messages.toString(e, debug) + " to " + this.files.toString(e, debug);
    }
}

