/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.lang.Conditional;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.Loop;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.lang.TriggerSection;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;

public class EffExit
extends Effect {
    private int breakLevels;
    private static final int EVERYTHING = 0;
    private static final int LOOPS = 1;
    private static final int CONDITIONALS = 2;
    private static final String[] names;
    private int type;

    static {
        Skript.registerEffect(EffExit.class, "(exit|stop) [trigger]", "(exit|stop) [(1|a|the|this)] (0\u00a6section|1\u00a6loop|2\u00a6conditional)", "(exit|stop) <\\d+> (0\u00a6section|1\u00a6loop|2\u00a6conditional)s", "(exit|stop) all (0\u00a6section|1\u00a6loop|2\u00a6conditional)s");
        names = new String[]{"sections", "loops", "conditionals"};
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        switch (matchedPattern) {
            case 0: {
                this.breakLevels = ScriptLoader.currentSections.size() + 1;
                this.type = 0;
                break;
            }
            case 1: 
            case 2: {
                this.breakLevels = matchedPattern == 1 ? 1 : Integer.parseInt(parser.regexes.get(0).group());
                this.type = parser.mark;
                if (this.breakLevels <= this.numLevels()) break;
                if (this.numLevels() == 0) {
                    Skript.error("can't stop any " + names[this.type] + " as there are no " + names[this.type] + " present", ErrorQuality.SEMANTIC_ERROR);
                } else {
                    Skript.error("can't stop " + this.breakLevels + " " + names[this.type] + " as there are only " + this.numLevels() + " " + names[this.type] + " present", ErrorQuality.SEMANTIC_ERROR);
                }
                return false;
            }
            case 3: {
                this.type = parser.mark;
                this.breakLevels = this.numLevels();
                if (this.breakLevels != 0) break;
                Skript.error("can't stop any " + names[this.type] + " as there are no " + names[this.type] + " present", ErrorQuality.SEMANTIC_ERROR);
                return false;
            }
        }
        return true;
    }

    private final int numLevels() {
        if (this.type == 0) {
            return ScriptLoader.currentSections.size();
        }
        int r = 0;
        for (TriggerSection s : ScriptLoader.currentSections) {
            if (!(this.type == 2 ? s instanceof Conditional : s instanceof Loop)) continue;
            ++r;
        }
        return r;
    }

    @Override
    protected TriggerItem walk(Event e) {
        this.debug(e, false);
        TriggerItem n = this;
        int i = this.breakLevels;
        while (i > 0) {
            n = n.getParent();
            assert (n != null);
            if (this.type == 0) {
                --i;
                continue;
            }
            if (this.type == 2 && n instanceof Conditional) {
                --i;
                continue;
            }
            if (this.type != 1 || !(n instanceof Loop)) continue;
            --i;
        }
        return n instanceof Loop ? ((Loop)n).getActualNext() : n.getNext();
    }

    @Override
    protected void execute(Event e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "stop " + this.breakLevels + " " + names[this.type];
    }
}

