/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.EnchantmentType;
import ch.njol.skript.util.Utils;
import ch.njol.util.Kleenean;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

public class EffEnchant
extends Effect {
    private Expression<ItemStack> item;
    private Expression<EnchantmentType> enchs;

    static {
        Skript.registerEffect(EffEnchant.class, "enchant %itemstack% with %enchantmenttypes%", "disenchant %itemstack%");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.item = exprs[0];
        if (!Utils.contains(this.item.acceptChange(Changer.ChangeMode.SET), ItemStack.class)) {
            Skript.error(this.item + " cannot be changed, thus it cannot be (dis)enchanted");
            return false;
        }
        if (matchedPattern == 1) {
            this.enchs = exprs[1];
        }
        return true;
    }

    @Override
    protected void execute(Event e) {
        ItemStack i = this.item.getSingle(e);
        if (i == null) {
            return;
        }
        if (this.enchs == null) {
            for (Enchantment ench : i.getEnchantments().keySet()) {
                i.removeEnchantment(ench);
            }
            this.item.change(e, i, Changer.ChangeMode.SET);
        } else {
            EnchantmentType[] types = this.enchs.getArray(e);
            if (types.length == 0) {
                return;
            }
            EnchantmentType[] enchantmentTypeArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                EnchantmentType type = enchantmentTypeArray[n2];
                i.addUnsafeEnchantment(type.getType(), type.getLevel());
                ++n2;
            }
            this.item.change(e, i, Changer.ChangeMode.SET);
        }
    }

    @Override
    public String toString(Event e, boolean debug) {
        return this.enchs == null ? "disenchant " + this.item.toString(e, debug) : "enchant " + this.item.toString(e, debug) + " with " + this.enchs;
    }
}

