/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Checker;
import ch.njol.util.Kleenean;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

public class CondIsWearing
extends Condition {
    private Expression<Player> players;
    private Expression<ItemType> types;

    static {
        Skript.registerCondition(CondIsWearing.class, "%players% (is|are) wearing %itemtypes%", "%players% (isn't|is not|aren't|are not) wearing %itemtypes%");
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.players = vars[0];
        this.types = vars[1];
        this.setNegated(matchedPattern == 1);
        return true;
    }

    @Override
    public String toString(Event e, boolean debug) {
        return String.valueOf(this.players.toString(e, debug)) + (this.players.isSingle() ? " is" : " are") + (this.isNegated() ? "not " : "") + " wearing " + this.types;
    }

    @Override
    public boolean check(final Event e) {
        return this.players.check(e, new Checker<Player>(){

            @Override
            public boolean check(final Player p) {
                return CondIsWearing.this.types.check(e, new Checker<ItemType>(){

                    @Override
                    public boolean check(ItemType t) {
                        ItemStack[] itemStackArray = p.getInventory().getArmorContents();
                        int n = itemStackArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ItemStack is = itemStackArray[n2];
                            if (t.isOfType(is)) {
                                return true;
                            }
                            ++n2;
                        }
                        return false;
                    }
                }, CondIsWearing.this.isNegated());
            }
        });
    }
}

