/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Checker;
import ch.njol.util.Kleenean;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.Event;

public class CondIsOnline
extends Condition {
    private Expression<OfflinePlayer> players;

    static {
        Skript.registerCondition(CondIsOnline.class, "%offlineplayers% ((is|are) online|(is not|isn't|are not|aren't) offline)", "%offlineplayers% ((is|are) offline|(is not|isn't|are not|aren't) online)");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.players = exprs[0];
        this.setNegated(matchedPattern == 1);
        return true;
    }

    @Override
    public boolean check(Event e) {
        return this.players.check(e, new Checker<OfflinePlayer>(){

            @Override
            public boolean check(OfflinePlayer p) {
                return p.isOnline();
            }
        }, this.isNegated());
    }

    @Override
    public String toString(Event e, boolean debug) {
        return String.valueOf(this.players.toString(e, debug)) + " " + (this.players.isSingle() ? "is" : "are") + " " + (this.isNegated() ? "offline" : "online");
    }
}

