/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.Comparator;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.registrations.Comparators;
import ch.njol.util.Checker;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;
import org.bukkit.inventory.Inventory;

public class CondContains
extends Condition {
    private Expression<?> containers;
    private Expression<?> items;

    static {
        Skript.registerCondition(CondContains.class, "%inventories% ha(s|ve) %itemtypes% [in [(the[ir]|his|her|its)] inventory]", "%inventories/strings/objects% contain[s] %itemtypes/strings/objects%", "%inventories% do[es](n't| not) have %itemtypes% [in [(the[ir]|his|her|its)] inventory]", "%inventories/strings/objects% do[es](n't| not) contain %itemtypes/strings/objects%");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.containers = exprs[0];
        this.items = exprs[1];
        this.setNegated(matchedPattern >= 2);
        return true;
    }

    @Override
    public boolean check(final Event e) {
        return this.containers.check(e, new Checker<Object>(){

            @Override
            public boolean check(final Object container) {
                if (CondContains.this.containers.isSingle()) {
                    if (container instanceof Inventory) {
                        final Inventory invi = (Inventory)container;
                        return CondContains.this.items.check(e, new Checker<Object>(){

                            @Override
                            public boolean check(Object type) {
                                return type instanceof ItemType && ((ItemType)type).isContainedIn(invi);
                            }
                        }, CondContains.this.isNegated());
                    }
                    if (container instanceof String) {
                        final String s = ((String)container).toLowerCase();
                        return CondContains.this.items.check(e, new Checker<Object>(){

                            @Override
                            public boolean check(Object type) {
                                return type instanceof String && s.contains(((String)type).toLowerCase());
                            }
                        }, CondContains.this.isNegated());
                    }
                    return false;
                }
                return CondContains.this.items.check(e, new Checker<Object>(){

                    @Override
                    public boolean check(Object item) {
                        return Comparator.Relation.EQUAL.is(Comparators.compare(container, item));
                    }
                }, CondContains.this.isNegated());
            }
        });
    }

    @Override
    public String toString(Event e, boolean debug) {
        return String.valueOf(this.containers.toString(e, debug)) + (this.isNegated() ? " doesn't contain " : " contains ") + this.items.toString(e, debug);
    }
}

