/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;

public class CondChance
extends Condition {
    private Expression<Double> chance;
    boolean percent;

    static {
        Skript.registerCondition(CondChance.class, "chance of %number%(1\u00a6\\%|)");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.chance = exprs[0];
        this.percent = parser.mark == 1;
        return true;
    }

    @Override
    public boolean check(Event e) {
        Number n = this.chance.getSingle(e);
        if (n == null) {
            return false;
        }
        return Math.random() < (this.percent ? n.doubleValue() / 100.0 : n.doubleValue());
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "chance of " + this.chance.toString(e, debug) + (this.percent ? "%" : "");
    }
}

