/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.util.Checker;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class CondCanHold
extends Condition {
    private Expression<Inventory> invis;
    private Expression<ItemType> items;

    static {
        Skript.registerCondition(CondCanHold.class, "%inventories% (can hold|ha(s|ve) [enough] space (for|to hold)) %itemtypes%", "%inventories% (can(no|')t hold|(ha(s|ve) not|ha(s|ve)n't|do[es]n't have) [enough] space (for|to hold)) %itemtypes%");
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.invis = vars[0];
        this.items = vars[1];
        if (this.items instanceof Literal) {
            ItemType[] itemTypeArray = (ItemType[])((Literal)this.items).getAll();
            int n = itemTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ItemType t = itemTypeArray[n2];
                if (!(t = t.getItem()).isAll() && (t.getTypes().size() != 1 || t.getTypes().get(0).hasDataRange() || t.getTypes().get(0).getId() == -1)) {
                    Skript.error("The condition 'can hold' can currently only be used with aliases that start with 'every' or 'all', or only stand for one item and one data value.", ErrorQuality.SEMANTIC_ERROR);
                    return false;
                }
                ++n2;
            }
        }
        this.setNegated(matchedPattern == 1);
        return true;
    }

    @Override
    public boolean check(final Event e) {
        return this.invis.check(e, new Checker<Inventory>(){

            @Override
            public boolean check(final Inventory invi) {
                if (!CondCanHold.this.items.getAnd()) {
                    return CondCanHold.this.items.check(e, new Checker<ItemType>(){

                        @Override
                        public boolean check(ItemType t) {
                            return t.getItem().hasSpace(invi);
                        }
                    }, CondCanHold.this.isNegated());
                }
                final ItemStack[] buf = ItemType.getCopiedContents(invi);
                return CondCanHold.this.items.check(e, new Checker<ItemType>(){

                    @Override
                    public boolean check(ItemType t) {
                        return t.getItem().addTo(buf);
                    }
                }, CondCanHold.this.isNegated());
            }
        });
    }

    @Override
    public String toString(Event e, boolean debug) {
        return String.valueOf(this.invis.toString(e, debug)) + " can" + (this.isNegated() ? "'t" : "") + " hold " + this.items.toString(e, debug);
    }
}

