/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.command;

import ch.njol.skript.Skript;
import ch.njol.skript.command.Argument;
import ch.njol.skript.command.Commands;
import ch.njol.skript.command.ScriptCommandEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.lang.util.SimpleEvent;
import ch.njol.skript.localization.Language;
import ch.njol.skript.log.ParseLog;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.log.Verbosity;
import ch.njol.skript.util.Utils;
import ch.njol.util.StringUtils;
import ch.njol.util.Validate;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.entity.Player;
import org.bukkit.help.GenericCommandHelpTopic;
import org.bukkit.help.HelpMap;
import org.bukkit.help.HelpTopic;
import org.bukkit.help.HelpTopicComparator;
import org.bukkit.help.IndexHelpTopic;
import org.bukkit.plugin.Plugin;

public class ScriptCommand
implements CommandExecutor,
Serializable {
    private final String name;
    private final String label;
    private final List<String> aliases;
    private List<String> activeAliases;
    private final String permission;
    private final String permissionMessage;
    private final String description;
    private final String usage;
    private final Trigger trigger;
    private final String pattern;
    private final List<Argument<?>> arguments;
    public static final int PLAYERS = 1;
    public static final int CONSOLE = 2;
    public static final int BOTH = 3;
    final int executableBy;
    private transient PluginCommand bukkitCommand;
    private transient Command overriden = null;
    private transient Map<String, Command> overridenAliases;
    private transient Collection<HelpTopic> helps;

    public ScriptCommand(File script, String name, String pattern, List<Argument<?>> arguments, String description, String usage, List<String> aliases, String permission, String permissionMessage, int executableBy, List<TriggerItem> items) {
        Validate.notNull(name, pattern, arguments, description, usage, aliases, items);
        this.name = name;
        this.label = name.toLowerCase();
        this.permission = permission;
        this.permissionMessage = permissionMessage == null ? Language.get("commands.no permission message") : permissionMessage;
        this.aliases = aliases;
        this.activeAliases = new ArrayList<String>(aliases);
        this.description = Utils.replaceChatStyles(description);
        this.usage = Utils.replaceChatStyles(usage);
        this.executableBy = executableBy;
        this.pattern = pattern;
        this.arguments = arguments;
        this.trigger = new Trigger(script, "command /" + name, new SimpleEvent(), items);
        this.setupBukkitCommand();
    }

    private void setupBukkitCommand() {
        try {
            Constructor c = PluginCommand.class.getDeclaredConstructor(String.class, Plugin.class);
            c.setAccessible(true);
            this.bukkitCommand = (PluginCommand)c.newInstance(new Object[]{this.name, Skript.getInstance()});
            this.bukkitCommand.setAliases(this.aliases);
            this.bukkitCommand.setDescription(this.description);
            this.bukkitCommand.setLabel(this.label);
            this.bukkitCommand.setPermission(this.permission);
            this.bukkitCommand.setPermissionMessage(this.permissionMessage);
            this.bukkitCommand.setUsage(this.usage);
            this.bukkitCommand.setExecutor((CommandExecutor)this);
        }
        catch (Exception e) {
            Skript.outdatedError(e);
        }
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.setupBukkitCommand();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        this.execute(sender, label, StringUtils.join(args, " "));
        return true;
    }

    public boolean execute(CommandSender sender, String commandLabel, String rest) {
        if (sender instanceof Player) {
            if ((this.executableBy & 1) == 0) {
                sender.sendMessage(Language.get("commands.executable by players"));
                return false;
            }
        } else if ((this.executableBy & 2) == 0) {
            sender.sendMessage(Language.get("commands.executable by console"));
            return false;
        }
        if (this.permission != null && !sender.hasPermission(this.permission)) {
            sender.sendMessage(this.permissionMessage);
            return false;
        }
        ScriptCommandEvent event = new ScriptCommandEvent(this, sender);
        ParseLog log = SkriptLogger.startParseLog();
        boolean ok = SkriptParser.parseArguments(rest, this, event);
        log.stop();
        if (!ok) {
            if (log.hasError()) {
                sender.sendMessage(ChatColor.DARK_RED + log.getError().getMessage());
            }
            sender.sendMessage(Commands.m_usage.toString(this.usage));
            return false;
        }
        if (Skript.log(Verbosity.VERY_HIGH)) {
            Skript.info("# /" + this.name + " " + rest);
        }
        long startTrigger = System.nanoTime();
        this.trigger.execute(event);
        if (Skript.log(Verbosity.VERY_HIGH)) {
            Skript.info("# " + this.name + " took " + 1.0 * (double)(System.nanoTime() - startTrigger) / 1000000.0 + " milliseconds");
        }
        return true;
    }

    public void sendHelp(CommandSender sender) {
        if (!this.description.isEmpty()) {
            sender.sendMessage(this.description);
        }
        sender.sendMessage(ChatColor.GOLD + "Usage" + ChatColor.RESET + ": " + this.usage);
    }

    public List<Argument<?>> getArguments() {
        return this.arguments;
    }

    public String getPattern() {
        return this.pattern;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(SimpleCommandMap commandMap, Map<String, Command> knownCommands, Set<String> aliases) {
        SimpleCommandMap simpleCommandMap = commandMap;
        synchronized (simpleCommandMap) {
            this.overridenAliases = new HashMap<String, Command>();
            this.overriden = knownCommands.put(this.label, (Command)this.bukkitCommand);
            aliases.remove(this.label);
            Iterator<String> as = this.activeAliases.iterator();
            while (as.hasNext()) {
                String lowerAlias = as.next().toLowerCase();
                if (knownCommands.containsKey(lowerAlias) && !aliases.contains(lowerAlias)) {
                    as.remove();
                    continue;
                }
                this.overridenAliases.put(lowerAlias, knownCommands.put(lowerAlias, (Command)this.bukkitCommand));
                aliases.add(lowerAlias);
            }
            this.bukkitCommand.setAliases(this.activeAliases);
            this.bukkitCommand.register((CommandMap)commandMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(SimpleCommandMap commandMap, Map<String, Command> knownCommands, Set<String> aliases) {
        SimpleCommandMap simpleCommandMap = commandMap;
        synchronized (simpleCommandMap) {
            knownCommands.remove(this.label);
            aliases.removeAll(this.activeAliases);
            for (String string : this.activeAliases) {
                knownCommands.remove(string);
            }
            this.activeAliases = new ArrayList<String>(this.aliases);
            this.bukkitCommand.unregister((CommandMap)commandMap);
            this.bukkitCommand.setAliases(this.aliases);
            if (this.overriden != null) {
                knownCommands.put(this.label, this.overriden);
                this.overriden = null;
            }
            for (Map.Entry entry : this.overridenAliases.entrySet()) {
                if (entry.getValue() == null) continue;
                knownCommands.put((String)entry.getKey(), (Command)entry.getValue());
                aliases.add((String)entry.getKey());
            }
            this.overridenAliases.clear();
        }
    }

    public void registerHelp() {
        this.helps = new ArrayList<HelpTopic>();
        HelpMap help = Bukkit.getHelpMap();
        GenericCommandHelpTopic t = new GenericCommandHelpTopic((Command)this.bukkitCommand);
        help.addTopic((HelpTopic)t);
        this.helps.add((HelpTopic)t);
        HelpTopic aliases = help.getHelpTopic("Aliases");
        if (aliases != null && aliases instanceof IndexHelpTopic) {
            aliases.getFullText((CommandSender)Bukkit.getConsoleSender());
            try {
                Field topics = IndexHelpTopic.class.getDeclaredField("allTopics");
                topics.setAccessible(true);
                ArrayList<Commands.CommandAliasHelpTopic> as = new ArrayList<Commands.CommandAliasHelpTopic>((Collection)topics.get(aliases));
                for (String alias : this.activeAliases) {
                    Commands.CommandAliasHelpTopic at = new Commands.CommandAliasHelpTopic("/" + alias, "/" + this.getLabel(), help);
                    as.add(at);
                    this.helps.add(at);
                }
                Collections.sort(as, HelpTopicComparator.helpTopicComparatorInstance());
                topics.set(aliases, as);
            }
            catch (Exception e) {
                Skript.exception((Throwable)e, "error registering aliases for /" + this.getName());
            }
        }
    }

    public void unregisterHelp() {
        Bukkit.getHelpMap().getHelpTopics().removeAll(this.helps);
        HelpTopic aliases = Bukkit.getHelpMap().getHelpTopic("Aliases");
        if (aliases != null && aliases instanceof IndexHelpTopic) {
            try {
                Field topics = IndexHelpTopic.class.getDeclaredField("allTopics");
                topics.setAccessible(true);
                ArrayList as = new ArrayList((Collection)topics.get(aliases));
                as.removeAll(this.helps);
                topics.set(aliases, as);
            }
            catch (Exception e) {
                Skript.exception((Throwable)e, "error unregistering aliases for /" + this.getName());
            }
        }
        this.helps.clear();
    }

    public String getName() {
        return this.name;
    }

    public String getLabel() {
        return this.label;
    }

    public List<String> getAliases() {
        return this.aliases;
    }

    public List<String> getActiveAliases() {
        return this.activeAliases;
    }

    public PluginCommand getBukkitCommand() {
        return this.bukkitCommand;
    }

    public File getScript() {
        return this.trigger.getScript();
    }
}

