/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.classes.data;

import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.Comparator;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.registrations.Comparators;
import ch.njol.skript.util.Date;
import ch.njol.skript.util.StructureType;
import ch.njol.skript.util.Time;
import ch.njol.skript.util.Timeperiod;
import ch.njol.skript.util.Timespan;
import ch.njol.skript.util.Utils;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;

public class DefaultComparators {
    static {
        Comparators.registerComparator(Number.class, Number.class, new Comparator<Number, Number>(){

            @Override
            public Comparator.Relation compare(Number n1, Number n2) {
                double diff = n1.doubleValue() - n2.doubleValue();
                if (Math.abs(diff) < 1.0E-10) {
                    return Comparator.Relation.EQUAL;
                }
                return Comparator.Relation.get(diff);
            }

            @Override
            public boolean supportsOrdering() {
                return true;
            }
        });
        Comparators.registerComparator(ItemStack.class, ItemType.class, new Comparator<ItemStack, ItemType>(){

            @Override
            public Comparator.Relation compare(ItemStack is, ItemType it) {
                return Comparator.Relation.get(it.isOfType(is));
            }

            @Override
            public boolean supportsOrdering() {
                return false;
            }
        });
        Comparators.registerComparator(Block.class, ItemType.class, new Comparator<Block, ItemType>(){

            @Override
            public Comparator.Relation compare(Block b, ItemType it) {
                return Comparator.Relation.get(it.isOfType(b));
            }

            @Override
            public boolean supportsOrdering() {
                return false;
            }
        });
        Comparators.registerComparator(ItemType.class, ItemType.class, new Comparator<ItemType, ItemType>(){

            @Override
            public Comparator.Relation compare(ItemType i1, ItemType i2) {
                return Comparator.Relation.get(i2.isSupertypeOf(i1));
            }

            @Override
            public boolean supportsOrdering() {
                return false;
            }
        });
        Comparators.registerComparator(Block.class, Block.class, new Comparator<Block, Block>(){

            @Override
            public Comparator.Relation compare(Block b1, Block b2) {
                return Comparator.Relation.get(b1.equals(b2));
            }

            @Override
            public boolean supportsOrdering() {
                return false;
            }
        });
        Comparators.registerComparator(Entity.class, EntityData.class, new Comparator<Entity, EntityData>(){

            @Override
            public Comparator.Relation compare(Entity e, EntityData t) {
                return Comparator.Relation.get(t.isInstance(e));
            }

            @Override
            public boolean supportsOrdering() {
                return false;
            }
        });
        Comparators.registerComparator(EntityData.class, EntityData.class, new Comparator<EntityData, EntityData>(){

            @Override
            public Comparator.Relation compare(EntityData t1, EntityData t2) {
                return Comparator.Relation.get(t2.isSupertypeOf(t1));
            }

            @Override
            public boolean supportsOrdering() {
                return false;
            }
        });
        Comparators.registerComparator(Date.class, Date.class, new Comparator<Date, Date>(){

            @Override
            public Comparator.Relation compare(Date d1, Date d2) {
                return Comparator.Relation.get(d1.compareTo(d2));
            }

            @Override
            public boolean supportsOrdering() {
                return true;
            }
        });
        Comparators.registerComparator(Time.class, Time.class, new Comparator<Time, Time>(){

            @Override
            public Comparator.Relation compare(Time t1, Time t2) {
                return Comparator.Relation.get(t1.getTicks() - t2.getTicks());
            }

            @Override
            public boolean supportsOrdering() {
                return true;
            }
        });
        Comparators.registerComparator(Timespan.class, Timespan.class, new Comparator<Timespan, Timespan>(){

            @Override
            public Comparator.Relation compare(Timespan t1, Timespan t2) {
                return Comparator.Relation.get(t1.getMilliSeconds() - t2.getMilliSeconds());
            }

            @Override
            public boolean supportsOrdering() {
                return true;
            }
        });
        Comparators.registerComparator(Time.class, Timeperiod.class, new Comparator<Time, Timeperiod>(){

            @Override
            public Comparator.Relation compare(Time t, Timeperiod p) {
                return Comparator.Relation.get(p.contains(t));
            }

            @Override
            public boolean supportsOrdering() {
                return false;
            }
        });
        Comparators.registerComparator(OfflinePlayer.class, String.class, new Comparator<OfflinePlayer, String>(){

            @Override
            public Comparator.Relation compare(OfflinePlayer p, String name) {
                return Comparator.Relation.get(p.getName().equalsIgnoreCase(name));
            }

            @Override
            public boolean supportsOrdering() {
                return false;
            }
        });
        Comparators.registerComparator(World.class, String.class, new Comparator<World, String>(){

            @Override
            public Comparator.Relation compare(World w, String name) {
                return Comparator.Relation.get(w.getName().equalsIgnoreCase(name));
            }

            @Override
            public boolean supportsOrdering() {
                return false;
            }
        });
        Comparators.registerComparator(String.class, String.class, new Comparator<String, String>(){

            @Override
            public Comparator.Relation compare(String s1, String s2) {
                return Comparator.Relation.get(s1.equalsIgnoreCase(s2));
            }

            @Override
            public boolean supportsOrdering() {
                return false;
            }
        });
        Comparators.registerComparator(StructureType.class, StructureType.class, new Comparator<StructureType, StructureType>(){

            @Override
            public Comparator.Relation compare(StructureType s1, StructureType s2) {
                return Comparator.Relation.get(Utils.containsAll(s2.getTypes(), s2.getTypes()));
            }

            @Override
            public boolean supportsOrdering() {
                return false;
            }
        });
    }
}

