/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.classes.data;

import ch.njol.skript.classes.SerializableGetter;
import ch.njol.skript.command.CommandEvent;
import ch.njol.skript.registrations.EventValues;
import ch.njol.skript.util.BlockStateBlock;
import ch.njol.skript.util.DelayedChangeBlock;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Painting;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.block.BlockEvent;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.BlockFormEvent;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.BlockSpreadEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityEvent;
import org.bukkit.event.entity.EntityTameEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.painting.PaintingEvent;
import org.bukkit.event.painting.PaintingPlaceEvent;
import org.bukkit.event.player.PlayerBedEnterEvent;
import org.bukkit.event.player.PlayerBedLeaveEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerShearEntityEvent;
import org.bukkit.event.server.ServerCommandEvent;
import org.bukkit.event.vehicle.VehicleEvent;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.bukkit.event.weather.WeatherEvent;
import org.bukkit.event.world.StructureGrowEvent;
import org.bukkit.event.world.WorldEvent;
import org.bukkit.inventory.ItemStack;

public final class BukkitEventValues {
    static {
        EventValues.registerEventValue(WorldEvent.class, World.class, new SerializableGetter<World, WorldEvent>(){

            @Override
            public World get(WorldEvent e) {
                return e.getWorld();
            }
        }, 0);
        EventValues.registerEventValue(StructureGrowEvent.class, Block.class, new SerializableGetter<Block, StructureGrowEvent>(){

            @Override
            public Block get(StructureGrowEvent e) {
                return e.getLocation().getBlock();
            }
        }, 0);
        EventValues.registerEventValue(StructureGrowEvent.class, Block.class, new SerializableGetter<Block, StructureGrowEvent>(){

            @Override
            public Block get(StructureGrowEvent e) {
                for (BlockState bs : e.getBlocks()) {
                    if (!bs.getLocation().equals((Object)e.getLocation())) continue;
                    return new BlockStateBlock(bs);
                }
                return e.getLocation().getBlock();
            }
        }, 1);
        EventValues.registerEventValue(WeatherEvent.class, World.class, new SerializableGetter<World, WeatherEvent>(){

            @Override
            public World get(WeatherEvent e) {
                return e.getWorld();
            }
        }, 0);
        EventValues.registerEventValue(BlockEvent.class, Block.class, new SerializableGetter<Block, BlockEvent>(){

            @Override
            public Block get(BlockEvent e) {
                return e.getBlock();
            }
        }, 0);
        EventValues.registerEventValue(BlockEvent.class, World.class, new SerializableGetter<World, BlockEvent>(){

            @Override
            public World get(BlockEvent e) {
                return e.getBlock().getWorld();
            }
        }, 0);
        EventValues.registerEventValue(BlockEvent.class, Location.class, new SerializableGetter<Location, BlockEvent>(){

            @Override
            public Location get(BlockEvent e) {
                return e.getBlock().getLocation().add(0.5, 0.5, 0.5);
            }
        }, 0);
        EventValues.registerEventValue(BlockPlaceEvent.class, Player.class, new SerializableGetter<Player, BlockPlaceEvent>(){

            @Override
            public Player get(BlockPlaceEvent e) {
                return e.getPlayer();
            }
        }, 0);
        EventValues.registerEventValue(BlockPlaceEvent.class, Block.class, new SerializableGetter<Block, BlockPlaceEvent>(){

            @Override
            public Block get(BlockPlaceEvent e) {
                return new BlockStateBlock(e.getBlockReplacedState());
            }
        }, -1);
        EventValues.registerEventValue(BlockFadeEvent.class, Block.class, new SerializableGetter<Block, BlockFadeEvent>(){

            @Override
            public Block get(BlockFadeEvent e) {
                return e.getBlock();
            }
        }, -1);
        EventValues.registerEventValue(BlockFadeEvent.class, Block.class, new SerializableGetter<Block, BlockFadeEvent>(){

            @Override
            public Block get(BlockFadeEvent e) {
                return new DelayedChangeBlock(e.getBlock(), e.getNewState());
            }
        }, 0);
        EventValues.registerEventValue(BlockFadeEvent.class, Block.class, new SerializableGetter<Block, BlockFadeEvent>(){

            @Override
            public Block get(BlockFadeEvent e) {
                return new BlockStateBlock(e.getNewState());
            }
        }, 1);
        EventValues.registerEventValue(BlockFormEvent.class, Block.class, new SerializableGetter<Block, BlockFormEvent>(){

            @Override
            public Block get(BlockFormEvent e) {
                if (e instanceof BlockSpreadEvent) {
                    return e.getBlock();
                }
                return new BlockStateBlock(e.getNewState());
            }
        }, 0);
        EventValues.registerEventValue(BlockFormEvent.class, Block.class, new SerializableGetter<Block, BlockFormEvent>(){

            @Override
            public Block get(BlockFormEvent e) {
                return e.getBlock();
            }
        }, -1);
        EventValues.registerEventValue(BlockDamageEvent.class, Player.class, new SerializableGetter<Player, BlockDamageEvent>(){

            @Override
            public Player get(BlockDamageEvent e) {
                return e.getPlayer();
            }
        }, 0);
        EventValues.registerEventValue(BlockBreakEvent.class, Player.class, new SerializableGetter<Player, BlockBreakEvent>(){

            @Override
            public Player get(BlockBreakEvent e) {
                return e.getPlayer();
            }
        }, 0);
        EventValues.registerEventValue(BlockBreakEvent.class, Block.class, new SerializableGetter<Block, BlockBreakEvent>(){

            @Override
            public Block get(BlockBreakEvent e) {
                return e.getBlock();
            }
        }, -1);
        EventValues.registerEventValue(BlockBreakEvent.class, Block.class, new SerializableGetter<Block, BlockBreakEvent>(){

            @Override
            public Block get(BlockBreakEvent e) {
                return new DelayedChangeBlock(e.getBlock());
            }
        }, 0);
        EventValues.registerEventValue(BlockBreakEvent.class, Block.class, new SerializableGetter<Block, BlockBreakEvent>(){

            @Override
            public Block get(BlockBreakEvent e) {
                BlockState s;
                s.setType((s = e.getBlock().getState()).getType() == Material.ICE ? Material.STATIONARY_WATER : Material.AIR);
                return new BlockStateBlock(s, true);
            }
        }, 1);
        EventValues.registerEventValue(BlockIgniteEvent.class, Player.class, new SerializableGetter<Player, BlockIgniteEvent>(){

            @Override
            public Player get(BlockIgniteEvent e) {
                return e.getPlayer();
            }
        }, 0);
        EventValues.registerEventValue(BlockDispenseEvent.class, ItemStack.class, new SerializableGetter<ItemStack, BlockDispenseEvent>(){

            @Override
            public ItemStack get(BlockDispenseEvent e) {
                return e.getItem();
            }
        }, 0);
        EventValues.registerEventValue(SignChangeEvent.class, Player.class, new SerializableGetter<Player, SignChangeEvent>(){

            @Override
            public Player get(SignChangeEvent e) {
                return e.getPlayer();
            }
        }, 0);
        EventValues.registerEventValue(EntityEvent.class, Entity.class, new SerializableGetter<Entity, EntityEvent>(){

            @Override
            public Entity get(EntityEvent e) {
                return e.getEntity();
            }
        }, 0, "Use 'attacker' and/or 'victim' in damage events", EntityDamageEvent.class);
        EventValues.registerEventValue(EntityEvent.class, World.class, new SerializableGetter<World, EntityEvent>(){

            @Override
            public World get(EntityEvent e) {
                return e.getEntity().getWorld();
            }
        }, 0);
        EventValues.registerEventValue(EntityDamageEvent.class, EntityDamageEvent.DamageCause.class, new SerializableGetter<EntityDamageEvent.DamageCause, EntityDamageEvent>(){

            @Override
            public EntityDamageEvent.DamageCause get(EntityDamageEvent e) {
                return e.getCause();
            }
        }, 0);
        EventValues.registerEventValue(EntityDamageByEntityEvent.class, Projectile.class, new SerializableGetter<Projectile, EntityDamageByEntityEvent>(){

            @Override
            public Projectile get(EntityDamageByEntityEvent e) {
                if (e.getDamager() instanceof Projectile) {
                    return (Projectile)e.getDamager();
                }
                return null;
            }
        }, 0);
        EventValues.registerEventValue(EntityDeathEvent.class, Projectile.class, new SerializableGetter<Projectile, EntityDeathEvent>(){

            @Override
            public Projectile get(EntityDeathEvent e) {
                if (e.getEntity().getLastDamageCause() instanceof EntityDamageByEntityEvent && ((EntityDamageByEntityEvent)e.getEntity().getLastDamageCause()).getDamager() instanceof Projectile) {
                    return (Projectile)((EntityDamageByEntityEvent)e.getEntity().getLastDamageCause()).getDamager();
                }
                return null;
            }
        }, 0);
        EventValues.registerEventValue(EntityDeathEvent.class, EntityDamageEvent.DamageCause.class, new SerializableGetter<EntityDamageEvent.DamageCause, EntityDeathEvent>(){

            @Override
            public EntityDamageEvent.DamageCause get(EntityDeathEvent e) {
                return e.getEntity().getLastDamageCause().getCause();
            }
        }, 0);
        EventValues.registerEventValue(ProjectileHitEvent.class, Entity.class, new SerializableGetter<Entity, ProjectileHitEvent>(){

            @Override
            public Entity get(ProjectileHitEvent e) {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                return e.getEntity().getShooter();
            }
        }, 0, "Use 'projectile' and/or 'shooter' in projectile hit events", ProjectileHitEvent.class);
        EventValues.registerEventValue(ProjectileHitEvent.class, Projectile.class, new SerializableGetter<Projectile, ProjectileHitEvent>(){

            @Override
            public Projectile get(ProjectileHitEvent e) {
                return e.getEntity();
            }
        }, 0);
        EventValues.registerEventValue(ProjectileLaunchEvent.class, Entity.class, new SerializableGetter<Entity, ProjectileLaunchEvent>(){

            @Override
            public Entity get(ProjectileLaunchEvent e) {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                return e.getEntity().getShooter();
            }
        }, 0, "Use 'projectile' and/or 'shooter' in shoot events", ProjectileLaunchEvent.class);
        EventValues.registerEventValue(ProjectileLaunchEvent.class, Projectile.class, new SerializableGetter<Projectile, ProjectileLaunchEvent>(){

            @Override
            public Projectile get(ProjectileLaunchEvent e) {
                return e.getEntity();
            }
        }, 0);
        EventValues.registerEventValue(EntityTameEvent.class, Player.class, new SerializableGetter<Player, EntityTameEvent>(){

            @Override
            public Player get(EntityTameEvent e) {
                return e.getOwner() instanceof Player ? (Player)e.getOwner() : null;
            }
        }, 0);
        EventValues.registerEventValue(PlayerEvent.class, Player.class, new SerializableGetter<Player, PlayerEvent>(){

            @Override
            public Player get(PlayerEvent e) {
                return e.getPlayer();
            }
        }, 0);
        EventValues.registerEventValue(PlayerEvent.class, World.class, new SerializableGetter<World, PlayerEvent>(){

            @Override
            public World get(PlayerEvent e) {
                return e.getPlayer().getWorld();
            }
        }, 0);
        EventValues.registerEventValue(PlayerBedEnterEvent.class, Block.class, new SerializableGetter<Block, PlayerBedEnterEvent>(){

            @Override
            public Block get(PlayerBedEnterEvent e) {
                return e.getBed();
            }
        }, 0);
        EventValues.registerEventValue(PlayerBedLeaveEvent.class, Block.class, new SerializableGetter<Block, PlayerBedLeaveEvent>(){

            @Override
            public Block get(PlayerBedLeaveEvent e) {
                return e.getBed();
            }
        }, 0);
        EventValues.registerEventValue(PlayerBucketFillEvent.class, Block.class, new SerializableGetter<Block, PlayerBucketFillEvent>(){

            @Override
            public Block get(PlayerBucketFillEvent e) {
                return e.getBlockClicked().getRelative(e.getBlockFace());
            }
        }, 0);
        EventValues.registerEventValue(PlayerBucketFillEvent.class, Block.class, new SerializableGetter<Block, PlayerBucketFillEvent>(){

            @Override
            public Block get(PlayerBucketFillEvent e) {
                BlockState s = e.getBlockClicked().getRelative(e.getBlockFace()).getState();
                s.setTypeId(0);
                s.setRawData((byte)0);
                return new BlockStateBlock(s, true);
            }
        }, 1);
        EventValues.registerEventValue(PlayerBucketEmptyEvent.class, Block.class, new SerializableGetter<Block, PlayerBucketEmptyEvent>(){

            @Override
            public Block get(PlayerBucketEmptyEvent e) {
                return e.getBlockClicked().getRelative(e.getBlockFace());
            }
        }, -1);
        EventValues.registerEventValue(PlayerBucketEmptyEvent.class, Block.class, new SerializableGetter<Block, PlayerBucketEmptyEvent>(){

            @Override
            public Block get(PlayerBucketEmptyEvent e) {
                BlockState s = e.getBlockClicked().getRelative(e.getBlockFace()).getState();
                s.setType(e.getBucket() == Material.WATER_BUCKET ? Material.STATIONARY_WATER : Material.STATIONARY_LAVA);
                s.setRawData((byte)0);
                return new BlockStateBlock(s, true);
            }
        }, 0);
        EventValues.registerEventValue(PlayerDropItemEvent.class, Item.class, new SerializableGetter<Item, PlayerDropItemEvent>(){

            @Override
            public Item get(PlayerDropItemEvent e) {
                return e.getItemDrop();
            }
        }, 0);
        EventValues.registerEventValue(PlayerDropItemEvent.class, ItemStack.class, new SerializableGetter<ItemStack, PlayerDropItemEvent>(){

            @Override
            public ItemStack get(PlayerDropItemEvent e) {
                return e.getItemDrop().getItemStack();
            }
        }, 0);
        EventValues.registerEventValue(PlayerInteractEntityEvent.class, Entity.class, new SerializableGetter<Entity, PlayerInteractEntityEvent>(){

            @Override
            public Entity get(PlayerInteractEntityEvent e) {
                return e.getRightClicked();
            }
        }, 0);
        EventValues.registerEventValue(PlayerInteractEvent.class, Block.class, new SerializableGetter<Block, PlayerInteractEvent>(){

            @Override
            public Block get(PlayerInteractEvent e) {
                return e.getClickedBlock();
            }
        }, 0);
        EventValues.registerEventValue(PlayerShearEntityEvent.class, Entity.class, new SerializableGetter<Entity, PlayerShearEntityEvent>(){

            @Override
            public Entity get(PlayerShearEntityEvent e) {
                return e.getEntity();
            }
        }, 0);
        EventValues.registerEventValue(PaintingEvent.class, Painting.class, new SerializableGetter<Painting, PaintingEvent>(){

            @Override
            public Painting get(PaintingEvent e) {
                return e.getPainting();
            }
        }, 0);
        EventValues.registerEventValue(PaintingEvent.class, World.class, new SerializableGetter<World, PaintingEvent>(){

            @Override
            public World get(PaintingEvent e) {
                return e.getPainting().getWorld();
            }
        }, 0);
        EventValues.registerEventValue(PaintingPlaceEvent.class, Player.class, new SerializableGetter<Player, PaintingPlaceEvent>(){

            @Override
            public Player get(PaintingPlaceEvent e) {
                return e.getPlayer();
            }
        }, 0);
        EventValues.registerEventValue(VehicleEvent.class, Vehicle.class, new SerializableGetter<Vehicle, VehicleEvent>(){

            @Override
            public Vehicle get(VehicleEvent e) {
                return e.getVehicle();
            }
        }, 0);
        EventValues.registerEventValue(VehicleEvent.class, World.class, new SerializableGetter<World, VehicleEvent>(){

            @Override
            public World get(VehicleEvent e) {
                return e.getVehicle().getWorld();
            }
        }, 0);
        EventValues.registerEventValue(VehicleExitEvent.class, LivingEntity.class, new SerializableGetter<LivingEntity, VehicleExitEvent>(){

            @Override
            public LivingEntity get(VehicleExitEvent e) {
                return e.getExited();
            }
        }, 0);
        EventValues.registerEventValue(VehicleEvent.class, Entity.class, new SerializableGetter<Entity, VehicleEvent>(){

            @Override
            public Entity get(VehicleEvent e) {
                return e.getVehicle().getPassenger();
            }
        }, 0);
        EventValues.registerEventValue(CommandEvent.class, CommandSender.class, new SerializableGetter<CommandSender, CommandEvent>(){

            @Override
            public CommandSender get(CommandEvent e) {
                return e.getSender();
            }
        }, 0);
        EventValues.registerEventValue(ServerCommandEvent.class, CommandSender.class, new SerializableGetter<CommandSender, ServerCommandEvent>(){

            @Override
            public CommandSender get(ServerCommandEvent e) {
                return e.getSender();
            }
        }, 0);
        EventValues.registerEventValue(InventoryClickEvent.class, Player.class, new SerializableGetter<Player, InventoryClickEvent>(){

            @Override
            public Player get(InventoryClickEvent e) {
                return e.getWhoClicked() instanceof Player ? (Player)e.getWhoClicked() : null;
            }
        }, 0);
        EventValues.registerEventValue(CraftItemEvent.class, ItemStack.class, new SerializableGetter<ItemStack, CraftItemEvent>(){

            @Override
            public ItemStack get(CraftItemEvent e) {
                return e.getRecipe().getResult();
            }
        }, 0);
    }
}

