/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Trigger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.EventExecutor;

public abstract class SkriptEventHandler {
    static Map<Class<? extends Event>, List<Trigger>> triggers = new HashMap<Class<? extends Event>, List<Trigger>>();
    static final EventExecutor ee = new EventExecutor(){

        public void execute(Listener l, Event e) {
            SkriptEventHandler.check(e);
        }
    };
    private static Event last = null;
    private static long startEvent;
    static long startTrigger;

    private SkriptEventHandler() {
    }

    static void check(Event e) {
        if (!Skript.listenerEnabled) {
            return;
        }
        if (last == e) {
            return;
        }
        last = e;
        List<Trigger> ts = triggers.get(e.getClass());
        if (ts == null) {
            return;
        }
        if (Skript.logVeryHigh()) {
            boolean hasTrigger = false;
            for (Trigger t : ts) {
                if (!t.getEvent().check(e)) continue;
                hasTrigger = true;
                break;
            }
            if (!hasTrigger) {
                return;
            }
        }
        SkriptEventHandler.logEventStart(e);
        if (e instanceof Cancellable && ((Cancellable)e).isCancelled() && (!(e instanceof PlayerInteractEvent) || ((PlayerInteractEvent)e).getAction() != Action.LEFT_CLICK_AIR && ((PlayerInteractEvent)e).getAction() != Action.RIGHT_CLICK_AIR || ((PlayerInteractEvent)e).useItemInHand() == Event.Result.DENY)) {
            if (Skript.logVeryHigh()) {
                Skript.info(" -x- was cancelled");
            }
            return;
        }
        for (Trigger t : ts) {
            if (!t.getEvent().check(e)) continue;
            SkriptEventHandler.logTriggerStart(t);
            t.execute(e);
            SkriptEventHandler.logTriggerEnd(t);
        }
        Skript.enableListener();
        SkriptEventHandler.logEventEnd();
    }

    public static void logEventStart(Event e) {
        if (!Skript.logVeryHigh()) {
            return;
        }
        startEvent = System.nanoTime();
        Skript.info("");
        Skript.info("== " + e.getClass().getName() + " ==");
    }

    public static void logEventEnd() {
        if (!Skript.logVeryHigh()) {
            return;
        }
        Skript.info("== took " + 1.0 * (double)(System.nanoTime() - startEvent) / 1000000.0 + " milliseconds ==");
    }

    public static void logTriggerStart(Trigger t) {
        if (!Skript.logVeryHigh()) {
            return;
        }
        Skript.info("# " + t.getName());
        startTrigger = System.nanoTime();
    }

    public static void logTriggerEnd(Trigger t) {
        if (!Skript.logVeryHigh()) {
            return;
        }
        Skript.info("# " + t.getName() + " took " + 1.0 * (double)(System.nanoTime() - startTrigger) / 1000000.0 + " milliseconds");
    }

    static void addTrigger(Class<? extends Event>[] events, Trigger trigger) {
        Class<? extends Event>[] classArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            Class<? extends Event> e = classArray[n2];
            List<Trigger> ts = triggers.get(e);
            if (ts == null) {
                ts = new ArrayList<Trigger>();
                triggers.put(e, ts);
            }
            ts.add(trigger);
            ++n2;
        }
    }
}

