/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.localization;

import ch.njol.skript.localization.Language;
import ch.njol.skript.localization.LanguageChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;

public class Message {
    private static final String EMPTYTOKEN = "---";
    private static final Collection<Message> messages = new ArrayList<Message>(50);
    public final String key;
    private String value;
    private boolean revalidate = true;

    static {
        Language.addListener(new LanguageChangeListener(){

            @Override
            public void onLanguageChange() {
                for (Message m : messages) {
                    m.revalidate = true;
                }
            }
        });
    }

    public Message(String key) {
        this.key = key.toLowerCase(Locale.ENGLISH);
        messages.add(this);
    }

    public String toString() {
        this.validate();
        return this.value == null ? this.key : this.value;
    }

    protected String getValue() {
        this.validate();
        return this.value;
    }

    protected void validate() {
        if (this.revalidate) {
            this.revalidate = false;
            this.value = Language.get_(this.key);
            if (this.value.equals(EMPTYTOKEN)) {
                this.value = "";
            }
            this.onValueChange();
        }
    }

    protected void onValueChange() {
    }
}

