/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang.util;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.Converter;
import ch.njol.skript.classes.SerializableConverter;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.registrations.Converters;
import ch.njol.util.Checker;
import ch.njol.util.Kleenean;
import java.util.Iterator;
import org.bukkit.event.Event;

public class ConvertedExpression<F, T>
implements Expression<T> {
    protected Expression<? extends F> source;
    protected Class<T> to;
    private final Converter<? super F, ? extends T> conv;

    public ConvertedExpression(Expression<? extends F> source, Class<T> to, SerializableConverter<? super F, ? extends T> conv) {
        this.source = source;
        this.to = to;
        this.conv = conv;
    }

    public static <F, T> ConvertedExpression<F, T> newInstance(Expression<F> v, Class<T> to) {
        if (v == null || to == null || to.isAssignableFrom(v.getReturnType())) {
            return null;
        }
        return ConvertedExpression.newInstance(v, v.getReturnType(), to);
    }

    private static <F, T> ConvertedExpression<F, T> newInstance(Expression<F> v, Class<? extends F> from, final Class<T> to) {
        if (from.isAssignableFrom(to)) {
            return new ConvertedExpression<F, T>(v, to, new SerializableConverter<F, T>(){
                private static final long serialVersionUID = 7203493497281269183L;

                @Override
                public T convert(F f) {
                    if (to.isInstance(f)) {
                        return f;
                    }
                    return null;
                }
            });
        }
        SerializableConverter<? extends F, T> c = Converters.getConverter(from, to);
        if (c == null) {
            return null;
        }
        return new ConvertedExpression<F, T>(v, to, c);
    }

    @Override
    public final boolean init(Expression<?>[] vars, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult matcher) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString(Event e, boolean debug) {
        if (debug && e == null) {
            return "(" + this.source.toString(e, debug) + ")->" + this.to.getName();
        }
        return this.source.toString(e, debug);
    }

    @Override
    public String toString() {
        return this.toString(null, false);
    }

    @Override
    public Class<T> getReturnType() {
        return this.to;
    }

    @Override
    public boolean isSingle() {
        return this.source.isSingle();
    }

    @Override
    public <R> Expression<? extends R> getConvertedExpression(Class<R> to) {
        if (to.isAssignableFrom(this.to)) {
            return this;
        }
        return this.source.getConvertedExpression(to);
    }

    @Override
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        return this.source.acceptChange(mode);
    }

    @Override
    public void change(Event e, Object delta, Changer.ChangeMode mode) {
        this.source.change(e, delta, mode);
    }

    @Override
    public T getSingle(Event e) {
        F f = this.source.getSingle(e);
        if (f == null) {
            return null;
        }
        return this.conv.convert(f);
    }

    @Override
    public T[] getArray(Event e) {
        return Converters.convert(this.source.getArray(e), this.to, this.conv);
    }

    @Override
    public T[] getAll(Event e) {
        return Converters.convert(this.source.getAll(e), this.to, this.conv);
    }

    @Override
    public boolean check(Event e, final Checker<? super T> c, boolean negated) {
        return this.source.check(e, new Checker<F>(){

            @Override
            public boolean check(F f) {
                Object t = ConvertedExpression.this.conv.convert(f);
                if (t == null) {
                    return false;
                }
                return c.check(t);
            }
        }, negated);
    }

    @Override
    public boolean check(Event e, final Checker<? super T> c) {
        return this.source.check(e, new Checker<F>(){

            @Override
            public boolean check(F f) {
                Object t = ConvertedExpression.this.conv.convert(f);
                if (t == null) {
                    return false;
                }
                return c.check(t);
            }
        });
    }

    @Override
    public boolean getAnd() {
        return this.source.getAnd();
    }

    @Override
    public boolean setTime(int time) {
        return this.source.setTime(time);
    }

    @Override
    public int getTime() {
        return this.source.getTime();
    }

    @Override
    public boolean isDefault() {
        return this.source.isDefault();
    }

    @Override
    public boolean isLoopOf(String s) {
        return false;
    }

    @Override
    public Iterator<T> iterator(Event e) {
        final Iterator<? extends F> iter = this.source.iterator(e);
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public T next() {
                return ConvertedExpression.this.conv.convert(iter.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Expression<?> getSource() {
        return this.source;
    }

    @Override
    public Expression<? extends T> simplify() {
        return this.source.simplify().getConvertedExpression(this.to);
    }
}

