/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang;

import ch.njol.skript.config.SectionNode;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.lang.TriggerSection;
import org.bukkit.event.Event;

public class Conditional
extends TriggerSection {
    private final Condition cond;
    private TriggerSection elseClause = null;

    public Conditional(Condition cond, SectionNode node) {
        super(node);
        this.cond = cond;
    }

    @Override
    protected TriggerItem walk(Event e) {
        if (this.cond.run(e)) {
            return this.walk(e, true);
        }
        this.debug(e, false);
        if (this.elseClause != null) {
            return this.elseClause;
        }
        return this.getNext();
    }

    @Override
    public String toString(Event e, boolean debug) {
        return this.cond.toString(e, debug);
    }

    public void loadElseClause(SectionNode node) {
        assert (this.elseClause == null || this.elseClause instanceof Conditional);
        if (this.elseClause != null) {
            ((Conditional)this.elseClause).loadElseClause(node);
            return;
        }
        this.elseClause = new TriggerSection(node){
            private static final long serialVersionUID = -7199203950275667534L;

            @Override
            public TriggerItem walk(Event e) {
                return this.walk(e, true);
            }

            @Override
            public String toString(Event e, boolean debug) {
                return "else";
            }
        };
        this.elseClause.setParent(this.getParent());
        this.elseClause.setNext(this.getNext());
    }

    public void loadElseIf(Condition cond, SectionNode n) {
        assert (this.elseClause == null || this.elseClause instanceof Conditional);
        if (this.elseClause != null) {
            ((Conditional)this.elseClause).loadElseIf(cond, n);
            return;
        }
        this.elseClause = new Conditional(cond, n);
        this.elseClause.setParent(this.getParent());
        this.elseClause.setNext(this.getNext());
    }

    public boolean hasElseClause() {
        return this.elseClause != null && !(this.elseClause instanceof Conditional);
    }

    @Override
    public void setNext(TriggerItem next) {
        super.setNext(next);
        if (this.elseClause != null) {
            this.elseClause.setNext(next);
        }
    }

    @Override
    public void setParent(TriggerSection parent) {
        super.setParent(parent);
        if (this.elseClause != null) {
            this.elseClause.setParent(parent);
        }
    }
}

