/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions.base;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.SkriptAPIException;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.SerializableChanger;
import ch.njol.skript.classes.SerializableGetter;
import ch.njol.skript.lang.DefaultExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.skript.log.SimpleLog;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.registrations.EventValues;
import ch.njol.skript.util.Getter;
import ch.njol.util.Kleenean;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.event.Event;

public class EventValueExpression<T>
extends SimpleExpression<T>
implements DefaultExpression<T> {
    private final Class<? extends T> c;
    private SerializableChanger<? super T, ?> changer;
    private final Map<Class<? extends Event>, SerializableGetter<? extends T, ?>> getters = new HashMap();

    public EventValueExpression(Class<? extends T> c) {
        this(c, null);
    }

    public EventValueExpression(Class<? extends T> c, SerializableChanger<? super T, ?> changer) {
        assert (c != null);
        this.c = c;
        this.changer = changer;
    }

    @Override
    protected T[] get(Event e) {
        T o = this.getValue(e);
        if (o == null) {
            return null;
        }
        Object[] one = (Object[])Array.newInstance(this.c, 1);
        one[0] = o;
        return one;
    }

    private <E extends Event> T getValue(E e) {
        if (this.getters.containsKey(e.getClass())) {
            Getter g = this.getters.get(e.getClass());
            return g == null ? null : (T)g.get(e);
        }
        for (Map.Entry<Class<Event>, SerializableGetter<T, ?>> p : this.getters.entrySet()) {
            if (!p.getKey().isAssignableFrom(e.getClass())) continue;
            this.getters.put(e.getClass(), p.getValue());
            return p.getValue() == null ? null : (T)((Getter)p.getValue()).get(e);
        }
        this.getters.put(e.getClass(), null);
        return null;
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        if (exprs.length != 0) {
            throw new SkriptAPIException(String.valueOf(this.getClass().getName()) + " has expressions in it's pattern but does not override init(...)");
        }
        return this.init();
    }

    @Override
    public boolean init() {
        boolean hasValue = false;
        SimpleLog log = SkriptLogger.startSubLog();
        Class<? extends Event>[] classArray = ScriptLoader.currentEvents;
        int n = ScriptLoader.currentEvents.length;
        int n2 = 0;
        while (n2 < n) {
            Class<? extends Event> e = classArray[n2];
            if (this.getters.containsKey(e)) {
                hasValue = true;
            } else {
                SerializableGetter<? extends T, ? extends Event> getter = EventValues.getEventValueGetter(e, this.c, this.getTime());
                if (getter != null) {
                    this.getters.put(e, getter);
                    hasValue = true;
                }
            }
            ++n2;
        }
        log.stop();
        if (!hasValue) {
            SkriptLogger.error(log.getFirstError("There's no " + Classes.getSuperClassInfo(this.c).getName() + " in this event"), ErrorQuality.NOT_AN_EXPRESSION);
            return false;
        }
        log.printLog();
        return true;
    }

    @Override
    public Class<? extends T> getReturnType() {
        return this.c;
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public String toString(Event e, boolean debug) {
        if (!debug || e == null) {
            return "event-" + Classes.getSuperClassInfo(this.c).getName();
        }
        return Classes.getDebugMessage(this.getValue(e));
    }

    @Override
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (this.changer == null) {
            this.changer = Classes.getSuperClassInfo(this.c).getChanger();
        }
        return this.changer.acceptChange(mode);
    }

    @Override
    public void change(Event e, Object delta, Changer.ChangeMode mode) {
        if (this.changer == null) {
            throw new UnsupportedOperationException();
        }
        Changer.ChangerUtils.change(this.changer, this.getArray(e), delta, mode);
    }

    @Override
    public boolean setTime(int time) {
        Class<? extends Event>[] classArray = ScriptLoader.currentEvents;
        int n = ScriptLoader.currentEvents.length;
        int n2 = 0;
        while (n2 < n) {
            Class<? extends Event> e = classArray[n2];
            if (EventValues.doesEventValueHaveTimeStates(e, this.c)) {
                super.setTime(time);
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean isDefault() {
        return true;
    }

    @Override
    public boolean getAnd() {
        return true;
    }
}

