/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.Converter;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.Utils;
import ch.njol.util.Kleenean;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;

public class ExprTarget
extends PropertyExpression<LivingEntity, Entity> {
    private EntityData<?> type;

    static {
        Skript.registerExpression(ExprTarget.class, Entity.class, ExpressionType.NORMAL, "[the] target[[ed] <.+>] [of %livingentities%]", "%livingentities%'[s] target[[ed] <.+>]");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        EntityData<Object> entityData = this.type = parser.regexes.isEmpty() ? EntityData.fromClass(Entity.class) : EntityData.parseWithoutAnOrAny(parser.regexes.get(0).group());
        if (this.type == null) {
            return false;
        }
        this.setExpr(exprs[0]);
        return true;
    }

    protected Entity[] get(Event evt, LivingEntity[] source) {
        return this.get(source, new Converter<LivingEntity, Entity>(){

            @Override
            public Entity convert(LivingEntity e) {
                return Utils.getTarget(e, ExprTarget.this.type);
            }
        });
    }

    @Override
    public Class<? extends Entity> getReturnType() {
        return this.type.getType();
    }

    @Override
    public String toString(Event e, boolean debug) {
        if (e == null) {
            return "the targeted " + this.type + " of " + this.getExpr().toString(e, debug);
        }
        return Classes.getDebugMessage(this.getAll(e));
    }

    @Override
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.CLEAR || mode == Changer.ChangeMode.SET) {
            return Skript.array(LivingEntity.class);
        }
        return null;
    }

    @Override
    public void change(Event e, Object delta, Changer.ChangeMode mode) {
        LivingEntity target = (LivingEntity)delta;
        LivingEntity[] livingEntityArray = (LivingEntity[])this.getExpr().getArray(e);
        int n = livingEntityArray.length;
        int n2 = 0;
        while (n2 < n) {
            LivingEntity entity = livingEntityArray[n2];
            if (entity instanceof Creature) {
                ((Creature)entity).setTarget(target);
            }
            ++n2;
        }
    }
}

