/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Converter;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Direction;
import ch.njol.util.Kleenean;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.event.Event;

public class ExprLightLevel
extends PropertyExpression<Location, Byte> {
    private final int SKY = 1;
    private final int BLOCK = 2;
    private final int ANY = -1;
    private int whatLight = -1;

    static {
        Skript.registerExpression(ExprLightLevel.class, Byte.class, ExpressionType.PROPERTY, "[(1\u00a6sky|1\u00a6sun|2\u00a6block)[ ]]light[ ]level [(of|%direction%) %location%]");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.setExpr(Direction.combine(exprs[0], exprs[1]));
        this.whatLight = parseResult.mark;
        return true;
    }

    @Override
    public Class<Byte> getReturnType() {
        return Byte.class;
    }

    @Override
    public String toString(Event e, boolean debug) {
        return String.valueOf(this.whatLight == 2 ? "block " : (this.whatLight == 1 ? "sky " : "")) + "light level " + this.getExpr().toString(e, debug);
    }

    protected Byte[] get(Event e, Location[] source) {
        return this.get(source, new Converter<Location, Byte>(){

            @Override
            public Byte convert(Location l) {
                Block b = l.getBlock();
                return ExprLightLevel.this.whatLight == -1 ? b.getLightLevel() : (ExprLightLevel.this.whatLight == 2 ? b.getLightFromBlocks() : b.getLightFromSky());
            }
        });
    }
}

