/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.ItemData;
import ch.njol.skript.util.ItemType;
import ch.njol.util.Kleenean;
import ch.njol.util.iterator.SingleItemIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.bukkit.event.Event;

public class ExprIdOf
extends PropertyExpression<ItemType, Integer> {
    private boolean single = false;

    static {
        Skript.registerExpression(ExprIdOf.class, Integer.class, ExpressionType.PROPERTY, "[the] id(1\u00a6s|) of %itemtype%", "%itemtype%'[s] id(1\u00a6s|)");
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.setExpr(vars[0]);
        if (parser.mark == -1) {
            this.single = true;
            if (!this.getExpr().isSingle() || this.getExpr() instanceof Literal && ((ItemType)((Literal)this.getExpr()).getSingle()).getTypes().size() != 1) {
                Skript.warning("'" + this.getExpr() + "' has multiple ids");
                this.single = false;
            }
        }
        return true;
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "the id" + (this.single ? "" : "s") + " of " + this.getExpr().toString(e, debug);
    }

    protected Integer[] get(Event e, ItemType[] source) {
        if (this.single) {
            ItemType t = (ItemType)this.getExpr().getSingle(e);
            if (t == null) {
                return null;
            }
            return new Integer[]{t.getTypes().get(0).getId()};
        }
        ArrayList<Integer> r = new ArrayList<Integer>();
        ItemType[] itemTypeArray = source;
        int n = source.length;
        int n2 = 0;
        while (n2 < n) {
            ItemType t = itemTypeArray[n2];
            for (ItemData d : t) {
                r.add(d.getId());
            }
            ++n2;
        }
        return r.toArray(new Integer[0]);
    }

    @Override
    public Iterator<Integer> iterator(Event e) {
        if (this.single) {
            ItemType t = (ItemType)this.getExpr().getSingle(e);
            if (t == null) {
                return null;
            }
            return new SingleItemIterator<Integer>(t.getTypes().get(0).getId());
        }
        final Iterator iter = this.getExpr().iterator(e);
        if (iter == null || !iter.hasNext()) {
            return null;
        }
        return new Iterator<Integer>(){
            private Iterator<ItemData> current;
            {
                this.current = ((ItemType)iterator.next()).iterator();
            }

            @Override
            public boolean hasNext() {
                while (iter.hasNext() && !this.current.hasNext()) {
                    this.current = ((ItemType)iter.next()).iterator();
                }
                return this.current.hasNext();
            }

            @Override
            public Integer next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.current.next().getId();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Class<Integer> getReturnType() {
        return Integer.class;
    }

    @Override
    public boolean isLoopOf(String s) {
        return s.equalsIgnoreCase("id");
    }
}

