/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.entity.XpOrbData;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.ItemType;
import ch.njol.skript.util.Utils;
import ch.njol.util.Kleenean;
import ch.njol.util.iterator.IteratorIterable;
import java.util.List;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class ExprDrops
extends SimpleExpression<ItemStack> {
    private Kleenean delay;

    static {
        Skript.registerExpression(ExprDrops.class, ItemStack.class, ExpressionType.SIMPLE, "[the] drops");
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        if (!Utils.contains(ScriptLoader.currentEvents, EntityDeathEvent.class)) {
            Skript.error("'drops' can only be used in death events", ErrorQuality.SEMANTIC_ERROR);
            return false;
        }
        this.delay = isDelayed;
        return true;
    }

    protected ItemStack[] get(Event e) {
        if (!(e instanceof EntityDeathEvent)) {
            return null;
        }
        return ((EntityDeathEvent)e).getDrops().toArray(new ItemStack[0]);
    }

    @Override
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (this.delay != Kleenean.FALSE) {
            Skript.error("Can't change the drops anymore after the event has already passed");
            return null;
        }
        return Skript.array(ItemType[].class, Inventory.class, XpOrbData.class);
    }

    @Override
    public void change(Event e, Object delta, Changer.ChangeMode mode) {
        if (!(e instanceof EntityDeathEvent)) {
            return;
        }
        if (delta instanceof XpOrbData) {
            if (mode == Changer.ChangeMode.REMOVE && ((XpOrbData)delta).getInternExperience() == -1) {
                ((EntityDeathEvent)e).setDroppedExp(0);
            } else {
                int xp = ((XpOrbData)delta).getExperience();
                if (mode == Changer.ChangeMode.ADD) {
                    xp += ((EntityDeathEvent)e).getDroppedExp();
                } else if (mode == Changer.ChangeMode.REMOVE) {
                    xp = ((EntityDeathEvent)e).getDroppedExp() - xp;
                }
                ((EntityDeathEvent)e).setDroppedExp(xp < 0 ? 0 : xp);
            }
        } else if (delta != null) {
            List drops = ((EntityDeathEvent)e).getDrops();
            switch (mode) {
                case SET: {
                    drops.clear();
                }
                case ADD: {
                    if (delta instanceof Inventory) {
                        for (ItemStack is : new IteratorIterable(((Inventory)delta).iterator())) {
                            if (is == null) continue;
                            drops.add(is);
                        }
                    } else {
                        ItemType[] itemTypeArray = (ItemType[])delta;
                        int n = itemTypeArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ItemType type = itemTypeArray[n2];
                            type.addTo(drops);
                            ++n2;
                        }
                    }
                    break;
                }
                case REMOVE: {
                    if (delta instanceof Inventory) {
                        for (ItemStack is : new IteratorIterable(((Inventory)delta).iterator())) {
                            if (is == null) continue;
                            new ItemType(is).removeFrom(drops);
                        }
                    } else {
                        ItemType[] itemTypeArray = (ItemType[])delta;
                        int n = itemTypeArray.length;
                        int n3 = 0;
                        while (n3 < n) {
                            ItemType type = itemTypeArray[n3];
                            type.removeFrom(drops);
                            ++n3;
                        }
                    }
                    break;
                }
                case CLEAR: {
                    drops.clear();
                }
            }
        }
    }

    @Override
    public Class<? extends ItemStack> getReturnType() {
        return ItemStack.class;
    }

    @Override
    public String toString(Event e, boolean debug) {
        if (e == null) {
            return "the drops";
        }
        return Classes.getDebugMessage(this.getAll(e));
    }

    @Override
    public boolean isSingle() {
        return false;
    }

    @Override
    public boolean getAnd() {
        return true;
    }
}

