/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.PlayerSlot;
import ch.njol.skript.util.Slot;
import ch.njol.util.Kleenean;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

public class ExprArmorSlot
extends SimplePropertyExpression<Player, Slot> {
    private int slot;
    private static final String[] slotNames;

    static {
        ExprArmorSlot.register(ExprArmorSlot.class, Slot.class, "(0\u00a6boot[s]|0\u00a6shoe[s]|1\u00a6leg[ging][s]|2\u00a6chestplate[s]|3\u00a6helm[et][s]) [slot]", "players");
        slotNames = new String[]{"boots", "leggings", "chestplate", "helmet"};
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        super.init(exprs, matchedPattern, isDelayed, parseResult);
        this.slot = parseResult.mark;
        return true;
    }

    @Override
    public Slot convert(final Player p) {
        return new PlayerSlot(p.getInventory()){

            @Override
            public ItemStack getItem() {
                return p.getInventory().getArmorContents()[ExprArmorSlot.this.slot];
            }

            @Override
            public void setItem(ItemStack item) {
                ItemStack[] armour = p.getInventory().getArmorContents();
                armour[((ExprArmorSlot)ExprArmorSlot.this).slot] = item;
                p.getInventory().setArmorContents(armour);
            }

            @Override
            public String toString(Event e, boolean debug) {
                return String.valueOf(slotNames[ExprArmorSlot.this.slot]) + " of " + p.getName();
            }
        };
    }

    @Override
    protected String getPropertyName() {
        return slotNames[this.slot];
    }

    @Override
    public Class<Slot> getReturnType() {
        return Slot.class;
    }
}

