/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.entity.EntityType;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Direction;
import ch.njol.util.Kleenean;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;

public class EffSpawn
extends Effect {
    private Expression<Location> locations;
    private Expression<EntityType> types;
    private Expression<Integer> amount;
    public static Entity lastSpawned;

    static {
        Skript.registerEffect(EffSpawn.class, "spawn %entitytypes% [%directions% %locations%]", "spawn %integer% of %entitytypes% [%directions% %locations%]");
        lastSpawned = null;
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.amount = matchedPattern == 0 ? null : exprs[0];
        this.types = exprs[matchedPattern];
        this.locations = Direction.combine(exprs[1 + matchedPattern], exprs[2 + matchedPattern]);
        return true;
    }

    @Override
    public void execute(Event e) {
        if (this.amount != null && this.amount.getSingle(e) == null) {
            return;
        }
        EntityType[] ts = this.types.getArray(e);
        int a = this.amount == null ? 1 : this.amount.getSingle(e);
        Location[] locationArray = this.locations.getArray(e);
        int n = locationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Location l = locationArray[n2];
            EntityType[] entityTypeArray = ts;
            int n3 = ts.length;
            int n4 = 0;
            while (n4 < n3) {
                EntityType type = entityTypeArray[n4];
                int i = 0;
                while (i < a * type.getAmount()) {
                    lastSpawned = type.data.spawn(l);
                    ++i;
                }
                ++n4;
            }
            ++n2;
        }
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "spawn " + this.types.toString(e, debug) + " " + this.locations.toString(e, debug);
    }
}

