/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Checker;
import ch.njol.util.Kleenean;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.Event;

public class CondPlayedBefore
extends Condition {
    private Expression<OfflinePlayer> player;

    static {
        Skript.registerCondition(CondPlayedBefore.class, "%offlineplayer% [(has|did)] [already] play[ed] [on (this|the) server] (before|already)", "%offlineplayer% (has not|hasn't|did not|didn't) [(already|yet)] play[ed] [on (this|the) server] (before|already|yet)");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.player = exprs[0];
        this.setNegated(matchedPattern == 1);
        return true;
    }

    @Override
    public boolean check(Event e) {
        return this.player.check(e, new Checker<OfflinePlayer>(){

            @Override
            public boolean check(OfflinePlayer p) {
                return p.hasPlayedBefore();
            }
        }, this.isNegated());
    }

    @Override
    public String toString(Event e, boolean debug) {
        return String.valueOf(this.player.toString(e, debug)) + " " + (this.isNegated() ? "hasn't" : "has") + " played on this server before";
    }
}

