/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.EnchantmentType;
import ch.njol.skript.util.ItemType;
import ch.njol.util.Checker;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;

public class CondIsEnchanted
extends Condition {
    private Expression<ItemType> items;
    private Expression<EnchantmentType> enchs;

    static {
        Skript.registerCondition(CondIsEnchanted.class, "%itemtypes% (is|are) enchanted [with %-enchantmenttype%]", "%itemtypes% (isn't|is not|aren't|are not) enchanted [with %-enchantmenttype%]");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.items = exprs[0];
        this.enchs = exprs[1];
        this.setNegated(matchedPattern == 1);
        return true;
    }

    @Override
    public boolean check(final Event e) {
        return this.items.check(e, new Checker<ItemType>(){

            @Override
            public boolean check(final ItemType item) {
                if (CondIsEnchanted.this.enchs == null) {
                    return item.getEnchantments() != null && !item.getEnchantments().isEmpty();
                }
                return CondIsEnchanted.this.enchs.check(e, new Checker<EnchantmentType>(){

                    @Override
                    public boolean check(EnchantmentType ench) {
                        return ench.has(item);
                    }
                }, CondIsEnchanted.this.isNegated());
            }
        });
    }

    @Override
    public String toString(Event e, boolean debug) {
        return String.valueOf(this.items.toString(e, debug)) + " " + (this.items.isSingle() ? "is" : "are") + (this.isNegated() ? " not" : "") + " enchanted" + (this.enchs == null ? "" : " with " + this.enchs.toString(e, debug));
    }
}

