/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.classes.data;

import ch.njol.skript.Aliases;
import ch.njol.skript.Skript;
import ch.njol.skript.classes.Arithmetic;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.EnumSerializer;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.classes.SerializableChanger;
import ch.njol.skript.classes.Serializer;
import ch.njol.skript.expressions.base.EventValueExpression;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.lang.util.SimpleLiteral;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.Color;
import ch.njol.skript.util.Date;
import ch.njol.skript.util.Direction;
import ch.njol.skript.util.EnchantmentType;
import ch.njol.skript.util.ItemData;
import ch.njol.skript.util.ItemType;
import ch.njol.skript.util.Slot;
import ch.njol.skript.util.StructureType;
import ch.njol.skript.util.Time;
import ch.njol.skript.util.Timeperiod;
import ch.njol.skript.util.Timespan;
import ch.njol.skript.util.WeatherType;
import java.util.Locale;
import java.util.Map;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;

public class SkriptClasses {
    static {
        Classes.registerClass(new ClassInfo<WeatherType>(WeatherType.class, "weathertype").user("weather ?types?", "weather conditions?", "weathers?").defaultExpression(new SimpleLiteral<WeatherType>(WeatherType.CLEAR, true)).parser(new Parser<WeatherType>(){

            @Override
            public WeatherType parse(String s, ParseContext context) {
                return WeatherType.parse(s);
            }

            @Override
            public String toString(WeatherType o) {
                return o.toString();
            }

            @Override
            public String toVariableNameString(WeatherType o) {
                return o.name().toLowerCase();
            }

            @Override
            public String getVariableNamePattern() {
                return "[a-z]+";
            }
        }).serializer(new EnumSerializer<WeatherType>(WeatherType.class)));
        Classes.registerClass(new ClassInfo<ItemType>(ItemType.class, "itemtype").user("item ?types?", "items", "materials").before("itemstack", "entitydata", "entitytype").after("number").parser(new Parser<ItemType>(){

            @Override
            public ItemType parse(String s, ParseContext context) {
                return Aliases.parseItemType(s);
            }

            @Override
            public String toString(ItemType t) {
                return t.toString();
            }

            @Override
            public String getDebugMessage(ItemType t) {
                return t.getDebugMessage();
            }

            @Override
            public String toVariableNameString(ItemType t) {
                StringBuilder b = new StringBuilder("itemtype:");
                b.append(t.getInternalAmount());
                b.append("," + t.isAll());
                for (ItemData itemData : t.getTypes()) {
                    b.append("," + itemData.getId());
                    b.append(":" + itemData.dataMin);
                    b.append("/" + itemData.dataMax);
                }
                if (!t.getEnchantments().isEmpty()) {
                    b.append("|");
                    for (Map.Entry entry : t.getEnchantments().entrySet()) {
                        b.append("#" + ((Enchantment)entry.getKey()).getId());
                        b.append(":" + entry.getValue());
                    }
                }
                return b.toString();
            }

            @Override
            public String getVariableNamePattern() {
                return "itemtype:.+";
            }
        }).serializer(new Serializer<ItemType>(){

            @Override
            public String serialize(ItemType t) {
                StringBuilder b = new StringBuilder();
                b.append(t.getInternalAmount());
                b.append("," + t.isAll());
                for (ItemData itemData : t.getTypes()) {
                    b.append("," + itemData.getId());
                    b.append(":" + itemData.dataMin);
                    b.append("/" + itemData.dataMax);
                }
                if (t.getEnchantments() != null) {
                    b.append("|");
                    for (Map.Entry entry : t.getEnchantments().entrySet()) {
                        b.append("#" + ((Enchantment)entry.getKey()).getId());
                        b.append(":" + entry.getValue());
                    }
                }
                return b.toString();
            }

            @Override
            public ItemType deserialize(String s) {
                ItemType t;
                String[] split;
                String[] ss;
                block17: {
                    ss = s.split("\\|");
                    if (ss.length > 2) {
                        return null;
                    }
                    split = ss[0].split("[,:/]");
                    if (split.length < 5 || (split.length - 2) % 3 != 0) {
                        return null;
                    }
                    t = new ItemType();
                    t.setAmount(Integer.parseInt(split[0]));
                    if (split[1].equals("true")) {
                        t.setAll(true);
                        break block17;
                    }
                    if (split[1].equals("false")) {
                        t.setAll(false);
                        break block17;
                    }
                    return null;
                }
                try {
                    int i = 2;
                    while (i < split.length) {
                        t.add(new ItemData(Integer.parseInt(split[i]), Short.parseShort(split[i + 1]), Short.parseShort(split[i + 2])));
                        i += 3;
                    }
                }
                catch (NumberFormatException e) {
                    return null;
                }
                if (ss.length == 2) {
                    if (ss[1].isEmpty()) {
                        t.emptyEnchantments();
                    } else {
                        String[] es;
                        String[] stringArray = es = ss[1].split("#");
                        int n = es.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String e = stringArray[n2];
                            if (!e.isEmpty()) {
                                Enchantment ench;
                                String[] en;
                                block18: {
                                    en = e.split(":");
                                    if (en.length != 2) {
                                        return null;
                                    }
                                    try {
                                        ench = Enchantment.getById((int)Integer.parseInt(en[0]));
                                        if (ench != null) break block18;
                                        return null;
                                    }
                                    catch (NumberFormatException ex) {
                                        return null;
                                    }
                                }
                                t.addEnchantment(ench, Integer.parseInt(en[1]));
                            }
                            ++n2;
                        }
                    }
                }
                return t;
            }
        }));
        Classes.registerClass(new ClassInfo<Time>(Time.class, "time").user("times?").defaultExpression(new EventValueExpression<Time>(Time.class)).parser(new Parser<Time>(){

            @Override
            public Time parse(String s, ParseContext context) {
                return Time.parse(s);
            }

            @Override
            public String toString(Time t) {
                return t.toString();
            }

            @Override
            public String toVariableNameString(Time o) {
                return "time:" + o.getTicks();
            }

            @Override
            public String getVariableNamePattern() {
                return "time:\\d+";
            }
        }).serializer(new Serializer<Time>(){

            @Override
            public String serialize(Time t) {
                return "" + t.getTicks();
            }

            @Override
            public Time deserialize(String s) {
                try {
                    return new Time(Integer.parseInt(s));
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
        }));
        Classes.registerClass(new ClassInfo<Timespan>(Timespan.class, "timespan").user("time ?spans?").parser(new Parser<Timespan>(){

            @Override
            public Timespan parse(String s, ParseContext context) {
                return Timespan.parse(s);
            }

            @Override
            public String toString(Timespan t) {
                return t.toString();
            }

            @Override
            public String toVariableNameString(Timespan o) {
                return "timespan:" + o.getMilliSeconds();
            }

            @Override
            public String getVariableNamePattern() {
                return "timespan:\\d+";
            }
        }).serializer(new Serializer<Timespan>(){

            @Override
            public String serialize(Timespan t) {
                return "" + t.getMilliSeconds();
            }

            @Override
            public Timespan deserialize(String s) {
                try {
                    return new Timespan(Integer.parseInt(s));
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
        }).math(Timespan.class, new Arithmetic<Timespan, Timespan>(){

            @Override
            public Timespan difference(Timespan t1, Timespan t2) {
                return new Timespan(Math.abs(t1.getMilliSeconds() - t2.getMilliSeconds()));
            }
        }));
        Classes.registerClass(new ClassInfo<Timeperiod>(Timeperiod.class, "timeperiod").user("time ?periods?", "durations?").defaultExpression(new SimpleLiteral<Timeperiod>(new Timeperiod(0, 23999), true)).parser(new Parser<Timeperiod>(){

            @Override
            public Timeperiod parse(String s, ParseContext context) {
                if (s.equalsIgnoreCase("day")) {
                    return new Timeperiod(0, 11999);
                }
                if (s.equalsIgnoreCase("dusk")) {
                    return new Timeperiod(12000, 13799);
                }
                if (s.equalsIgnoreCase("night")) {
                    return new Timeperiod(13800, 22199);
                }
                if (s.equalsIgnoreCase("dawn")) {
                    return new Timeperiod(22200, 23999);
                }
                int c = s.indexOf(45);
                if (c == -1) {
                    Time t = Time.parse(s);
                    if (t == null) {
                        return null;
                    }
                    return new Timeperiod(t.getTicks());
                }
                Time t1 = Time.parse(s.substring(0, c).trim());
                Time t2 = Time.parse(s.substring(c + 1).trim());
                if (t1 == null || t2 == null) {
                    return null;
                }
                return new Timeperiod(t1.getTicks(), t2.getTicks());
            }

            @Override
            public String toString(Timeperiod o) {
                return o.toString();
            }

            @Override
            public String toVariableNameString(Timeperiod o) {
                return "timeperiod:" + o.start + "-" + o.end;
            }

            @Override
            public String getVariableNamePattern() {
                return "timeperiod:\\d+-\\d+";
            }
        }).serializer(new Serializer<Timeperiod>(){

            @Override
            public String serialize(Timeperiod t) {
                return String.valueOf(t.start) + "-" + t.end;
            }

            @Override
            public Timeperiod deserialize(String s) {
                String[] split = s.split("-");
                if (split.length != 2) {
                    return null;
                }
                try {
                    return new Timeperiod(Integer.parseInt(split[0]), Integer.parseInt(split[1]));
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
        }));
        Classes.registerClass(new ClassInfo<Date>(Date.class, "date").user("dates?").serializer(new Serializer<Date>(){

            @Override
            public String serialize(Date d) {
                return "" + d.getTimestamp();
            }

            @Override
            public Date deserialize(String s) {
                try {
                    return new Date(Long.parseLong(s));
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
        }).math(Timespan.class, new Arithmetic<Date, Timespan>(){

            @Override
            public Timespan difference(Date first, Date second) {
                return first.difference(second);
            }
        }).changer(new SerializableChanger<Date, Timespan>(){
            private static final long serialVersionUID = 5598732197804454663L;

            public void change(Date[] what, Timespan delta, Changer.ChangeMode mode) {
                switch (mode) {
                    case ADD: {
                        Date[] dateArray = what;
                        int n = what.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Date d = dateArray[n2];
                            d.add(delta);
                            ++n2;
                        }
                        break;
                    }
                    case REMOVE: {
                        Date[] dateArray = what;
                        int n = what.length;
                        int n3 = 0;
                        while (n3 < n) {
                            Date d = dateArray[n3];
                            d.subtract(delta);
                            ++n3;
                        }
                        break;
                    }
                }
            }

            @Override
            public Class<? extends Timespan>[] acceptChange(Changer.ChangeMode mode) {
                if (mode == Changer.ChangeMode.CLEAR || mode == Changer.ChangeMode.SET) {
                    return null;
                }
                return Skript.array(Timespan.class);
            }
        }));
        Classes.registerClass(new ClassInfo<Direction>(Direction.class, "direction").user("direction").defaultExpression(new SimpleLiteral<Direction>(new Direction(new double[]{0.0, 0.0, 0.0}), true)).parser(new Parser<Direction>(){

            @Override
            public Direction parse(String s, ParseContext context) {
                return null;
            }

            @Override
            public boolean canParse(ParseContext context) {
                return false;
            }

            @Override
            public String toString(Direction o) {
                return o.toString();
            }

            @Override
            public String toVariableNameString(Direction o) {
                return "direction:" + o.serialize();
            }

            @Override
            public String getVariableNamePattern() {
                return "direction:.+";
            }
        }).serializer(new Serializer<Direction>(){

            @Override
            public String serialize(Direction o) {
                return o.serialize();
            }

            @Override
            public Direction deserialize(String s) {
                return Direction.deserialize(s);
            }
        }));
        Classes.registerClass(new ClassInfo<Slot>(Slot.class, "slot").user("(inventory )?slots?").defaultExpression(new EventValueExpression<Slot>(Slot.class)).changer(new SerializableChanger<Slot, ItemType>(){
            private static final long serialVersionUID = 392597470786335167L;

            @Override
            public Class<ItemType>[] acceptChange(Changer.ChangeMode mode) {
                return Skript.array(ItemType.class);
            }

            public void change(Slot[] slots, ItemType delta, Changer.ChangeMode mode) {
                ItemType type = delta;
                if (type == null && mode != Changer.ChangeMode.CLEAR) {
                    return;
                }
                Slot[] slotArray = slots;
                int n = slots.length;
                int n2 = 0;
                while (n2 < n) {
                    Slot slot = slotArray[n2];
                    switch (mode) {
                        case SET: {
                            slot.setItem(type.getItem().getRandom());
                            break;
                        }
                        case ADD: {
                            slot.setItem(type.getItem().addTo(slot.getItem()));
                            break;
                        }
                        case REMOVE: {
                            slot.setItem(type.removeFrom(slot.getItem()));
                            break;
                        }
                        case CLEAR: {
                            slot.setItem(null);
                        }
                    }
                    ++n2;
                }
            }
        }).serializeAs(ItemStack.class));
        Classes.registerClass(new ClassInfo<Color>(Color.class, "color").user("colou?rs?").parser(new Parser<Color>(){

            @Override
            public String toString(Color c) {
                return c.toString();
            }

            @Override
            public Color parse(String s, ParseContext context) {
                return Color.byName(s);
            }

            @Override
            public String toVariableNameString(Color o) {
                return o.name().toLowerCase(Locale.ENGLISH).replace('_', ' ');
            }

            @Override
            public String getVariableNamePattern() {
                return "[a-z ]+";
            }
        }).serializer(new EnumSerializer<Color>(Color.class)));
        Classes.registerClass(new ClassInfo<StructureType>(StructureType.class, "structuretype").user("tree ?types?", "trees?").parser(new Parser<StructureType>(){

            @Override
            public StructureType parse(String s, ParseContext context) {
                return StructureType.fromName(s);
            }

            @Override
            public String toString(StructureType o) {
                return o.toString().toLowerCase().replace('_', ' ');
            }

            @Override
            public String toVariableNameString(StructureType o) {
                return o.toString().toLowerCase().replace('_', ' ');
            }

            @Override
            public String getVariableNamePattern() {
                return "[a-z ]+";
            }
        }).serializer(new EnumSerializer<StructureType>(StructureType.class)));
        Classes.registerClass(new ClassInfo<EnchantmentType>(EnchantmentType.class, "enchantmenttype").parser(new Parser<EnchantmentType>(){

            @Override
            public EnchantmentType parse(String s, ParseContext context) {
                return EnchantmentType.parse(s);
            }

            @Override
            public String toString(EnchantmentType t) {
                return t.toString();
            }

            @Override
            public String toVariableNameString(EnchantmentType o) {
                return o.toString();
            }

            @Override
            public String getVariableNamePattern() {
                return ".+";
            }
        }).serializer(new Serializer<EnchantmentType>(){

            @Override
            public String serialize(EnchantmentType o) {
                return String.valueOf(o.getType().getId()) + ":" + o.getLevel();
            }

            @Override
            public EnchantmentType deserialize(String s) {
                Enchantment ench;
                String[] split;
                block4: {
                    split = s.split(":");
                    if (split.length != 2) {
                        return null;
                    }
                    try {
                        ench = Enchantment.getById((int)Integer.parseInt(split[0]));
                        if (ench != null) break block4;
                        return null;
                    }
                    catch (NumberFormatException e) {
                        return null;
                    }
                }
                return new EnchantmentType(ench, Integer.parseInt(split[1]));
            }
        }));
    }
}

