/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.classes;

import ch.njol.skript.classes.SerializableConverter;

public interface Converter<F, T> {
    public T convert(F var1);

    public static final class ConverterInfo<F, T> {
        public final Class<F> from;
        public final Class<T> to;
        public final SerializableConverter<F, T> converter;
        public final int options;

        public ConverterInfo(Class<F> from, Class<T> to, SerializableConverter<F, T> converter, int options) {
            this.from = from;
            this.to = to;
            this.converter = converter;
            this.options = options;
        }
    }

    public static final class ConverterOptions {
        public static final int NO_LEFT_CHAINING = 1;
        public static final int NO_RIGHT_CHAINING = 2;
        public static final int NO_CHAINING = 3;
    }

    public static final class ConverterUtils {
        public static final <F, T> SerializableConverter<?, T> createInstanceofConverter(ConverterInfo<F, T> conv) {
            return ConverterUtils.createInstanceofConverter(conv.from, conv.converter);
        }

        public static final <F, T> SerializableConverter<?, T> createInstanceofConverter(final Class<F> from, final Converter<F, T> conv) {
            return new SerializableConverter<Object, T>(){
                private static final long serialVersionUID = -9026052502252522895L;

                @Override
                public T convert(Object o) {
                    if (!from.isInstance(o)) {
                        return null;
                    }
                    return conv.convert(o);
                }
            };
        }

        public static final <F, T> SerializableConverter<F, T> createInstanceofConverter(Converter<F, ?> conv, final Class<T> to) {
            return new SerializableConverter<F, T>(){
                private static final long serialVersionUID = 2408973867196975702L;

                @Override
                public T convert(F f) {
                    Object o = Converter.this.convert(f);
                    if (to.isInstance(o)) {
                        return o;
                    }
                    return null;
                }
            };
        }

        public static final <F, T> SerializableConverter<?, T> createDoubleInstanceofConverter(ConverterInfo<F, ?> conv, Class<T> to) {
            return ConverterUtils.createDoubleInstanceofConverter(conv.from, conv.converter, to);
        }

        public static final <F, T> SerializableConverter<?, T> createDoubleInstanceofConverter(final Class<F> from, final Converter<F, ?> conv, final Class<T> to) {
            return new SerializableConverter<Object, T>(){
                private static final long serialVersionUID = 6009912617490506586L;

                @Override
                public T convert(Object o) {
                    if (!from.isInstance(o)) {
                        return null;
                    }
                    Object o2 = conv.convert(o);
                    if (to.isInstance(o2)) {
                        return o2;
                    }
                    return null;
                }
            };
        }
    }
}

