/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.classes;

import ch.njol.skript.classes.Converter;
import ch.njol.skript.classes.SerializableConverter;

public final class ChainedConverter<F, M, T>
implements SerializableConverter<F, T> {
    private final Converter<? super F, ? extends M> first;
    private final Converter<? super M, ? extends T> second;

    public ChainedConverter(SerializableConverter<? super F, ? extends M> first, SerializableConverter<? super M, ? extends T> second) {
        assert (first != null);
        assert (second != null);
        this.first = first;
        this.second = second;
    }

    public static final <F, M, T> ChainedConverter<F, M, T> newInstance(SerializableConverter<? super F, ?> first, SerializableConverter<?, ? extends T> second) {
        return new ChainedConverter(first, second);
    }

    @Override
    public T convert(F f) {
        M m = this.first.convert(f);
        if (m == null) {
            return null;
        }
        return this.second.convert(m);
    }
}

