/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.config.Config;
import ch.njol.skript.config.validate.EnumEntryValidator;
import ch.njol.skript.config.validate.SectionValidator;
import ch.njol.skript.localization.Language;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.log.Verbosity;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.Timespan;
import ch.njol.util.Setter;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import org.bukkit.event.EventPriority;

public abstract class SkriptConfig {
    static Config mainConfig;
    static Collection<Config> configs;
    static boolean keepConfigsLoaded;
    public static boolean enableEffectCommands;
    public static String effectCommandToken;
    static boolean checkForNewVersion;
    static boolean automaticallyDownloadNewVersion;
    public static boolean logPlayerCommands;
    public static boolean disableVariableConflictWarnings;
    public static Timespan variableBackupPeriod;
    private static DateFormat dateFormat;
    public static boolean enableScriptCaching;

    static {
        configs = new ArrayList<Config>();
        keepConfigsLoaded = false;
        enableEffectCommands = false;
        effectCommandToken = "!";
        checkForNewVersion = false;
        automaticallyDownloadNewVersion = false;
        logPlayerCommands = false;
        variableBackupPeriod = null;
        dateFormat = DateFormat.getDateTimeInstance(3, 3);
        enableScriptCaching = false;
    }

    private SkriptConfig() {
    }

    public static DateFormat getDateFormat() {
        return dateFormat;
    }

    static boolean load() {
        File config;
        block12: {
            block11: {
                try {
                    File oldConfig = new File(Skript.getInstance().getDataFolder(), "config.cfg");
                    config = new File(Skript.getInstance().getDataFolder(), "config.sk");
                    if (oldConfig.exists()) {
                        if (!config.exists()) {
                            oldConfig.renameTo(config);
                            Skript.info("[1.3] Renamed your 'config.cfg' to 'config.sk' to match the new format");
                        } else {
                            Skript.error("Found both a new and an old config, ingoring the old one");
                        }
                    }
                    if (config.exists()) break block11;
                    Skript.error("Config file 'config.sk' does not exist! Please make sure that you downloaded the .zip file (and not the .jar) from Skript's BukkitDev page and extracted it correctly.");
                    return false;
                }
                catch (Exception e) {
                    Skript.exception((Throwable)e, "error loading config");
                    return false;
                }
            }
            if (config.canRead()) break block12;
            Skript.error("Config file 'config.sk' cannot be read!");
            return false;
        }
        try {
            mainConfig = new Config(config, false, false, ":");
        }
        catch (IOException e) {
            Skript.error("Could not load the main config: " + e.getLocalizedMessage());
            return false;
        }
        new SectionValidator().addNode("verbosity", new EnumEntryValidator<Verbosity>(Verbosity.class, new Setter<Verbosity>(){

            @Override
            public void set(Verbosity v) {
                SkriptLogger.setVerbosity(v);
            }
        }), false).addNode("plugin priority", new EnumEntryValidator<EventPriority>(EventPriority.class, new Setter<EventPriority>(){

            @Override
            public void set(EventPriority p) {
                Skript.defaultEventPriority = p;
            }
        }, "lowest, low, normal, high, highest"), false).addEntry("keep configs loaded", Classes.getExactParser(Boolean.class), new Setter<Boolean>(){

            @Override
            public void set(Boolean b) {
                keepConfigsLoaded = b;
            }
        }, true).addEntry("enable effect commands", Classes.getExactParser(Boolean.class), new Setter<Boolean>(){

            @Override
            public void set(Boolean b) {
                enableEffectCommands = b;
            }
        }, false).addEntry("effect command token", new Setter<String>(){

            @Override
            public void set(String s) {
                if (s.startsWith("/")) {
                    Skript.error("Cannot use a token that starts with a slash because it can conflict with commands");
                } else {
                    effectCommandToken = s;
                }
            }
        }, false).addEntry("date format", new Setter<String>(){

            @Override
            public void set(String s) {
                try {
                    if (!s.equalsIgnoreCase("default")) {
                        SkriptConfig.dateFormat = new SimpleDateFormat(s);
                    }
                }
                catch (IllegalArgumentException e) {
                    Skript.error("'" + s + "' is not a valid date format. Please refer to http://docs.oracle.com/javase/6/docs/api/java/text/SimpleDateFormat.html for instructions on the format.");
                }
            }
        }, true).addEntry("disable variable conflict warnings", Classes.getExactParser(Boolean.class), new Setter<Boolean>(){

            @Override
            public void set(Boolean b) {
                disableVariableConflictWarnings = b;
            }
        }, true).addEntry("language", new Setter<String>(){

            @Override
            public void set(String s) {
                if (!Language.load(s)) {
                    Skript.error("No language file found for '" + s + "'!");
                }
            }
        }, true).addEntry("check for new version", Classes.getExactParser(Boolean.class), new Setter<Boolean>(){

            @Override
            public void set(Boolean b) {
                checkForNewVersion = b;
            }
        }, false).addEntry("automatically download new version", Classes.getExactParser(Boolean.class), new Setter<Boolean>(){

            @Override
            public void set(Boolean b) {
                automaticallyDownloadNewVersion = b;
            }
        }, false).addEntry("log player commands", Classes.getExactParser(Boolean.class), new Setter<Boolean>(){

            @Override
            public void set(Boolean b) {
                logPlayerCommands = b;
            }
        }, true).addEntry("variables backup interval", Classes.getExactParser(Timespan.class), new Setter<Timespan>(){

            @Override
            public void set(Timespan t) {
                if (t.getTicks() != 0) {
                    variableBackupPeriod = t;
                }
            }
        }, true).addEntry("enable script caching", Classes.getExactParser(Boolean.class), new Setter<Boolean>(){

            @Override
            public void set(Boolean b) {
                enableScriptCaching = b;
            }
        }, true).validate(mainConfig.getMainNode());
        if (!keepConfigsLoaded) {
            mainConfig = null;
        }
        return true;
    }
}

