/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.SkriptConfig;
import ch.njol.skript.config.Config;
import ch.njol.skript.config.EntryNode;
import ch.njol.skript.config.Node;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.config.validate.SectionValidator;
import ch.njol.skript.localization.Language;
import ch.njol.skript.log.SimpleLog;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.util.EnchantmentType;
import ch.njol.skript.util.ItemData;
import ch.njol.skript.util.ItemType;
import ch.njol.skript.util.Utils;
import ch.njol.util.Pair;
import ch.njol.util.Setter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;

public abstract class Aliases {
    private static final HashMap<String, ItemType> aliases = new HashMap(2500);
    private static final HashMap<Integer, MaterialName> materialNames = new HashMap(Material.values().length);
    private static final ItemType everything = new ItemType();
    private static Config aliasConfig;

    static {
        everything.setAll(true);
        everything.add(new ItemData());
    }

    private static final ItemType getAlias(String s) {
        ItemType t = ScriptLoader.currentAliases.get(s);
        if (t != null) {
            return t;
        }
        return aliases.get(s);
    }

    private static HashMap<String, ItemType> getAliases(String name, ItemType value, HashMap<String, HashMap<String, ItemType>> variations) {
        HashMap<String, ItemType> r = new HashMap<String, ItemType>();
        Matcher m = Pattern.compile("\\[(.+?)\\]").matcher(name);
        if (m.find()) {
            r.putAll(Aliases.getAliases(m.replaceFirst("").replace("  ", " "), value, variations));
            r.putAll(Aliases.getAliases(m.replaceFirst("$1"), value, variations));
        } else {
            m = Pattern.compile("\\((.+?)\\)").matcher(name);
            if (m.find()) {
                String[] split = m.group(1).split("\\|");
                if (split.length == 1) {
                    Skript.error("brackets have a special meaning in aliases and cannot be used as usual");
                }
                String[] stringArray = split;
                int n = split.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    r.putAll(Aliases.getAliases(m.replaceFirst(s), value, variations));
                    ++n2;
                }
            } else {
                m = Pattern.compile("\\{(.+?)\\}").matcher(name);
                if (m.find()) {
                    if (variations.get(m.group(1)) != null) {
                        boolean hasDefault = false;
                        for (Map.Entry<String, ItemType> v : variations.get(m.group(1)).entrySet()) {
                            String n;
                            if (v.getKey().equalsIgnoreCase("{default}")) {
                                hasDefault = true;
                                n = m.replaceFirst("").replace("  ", " ");
                            } else {
                                n = m.replaceFirst(v.getKey());
                            }
                            ItemType t = v.getValue().intersection(value);
                            if (t != null) {
                                r.putAll(Aliases.getAliases(n, t, variations));
                                continue;
                            }
                            Skript.warning("'" + n + "' results in an empty alias (i.e. it doesn't map to any id/data), it will thus be ignored");
                        }
                        if (!hasDefault) {
                            r.putAll(Aliases.getAliases(m.replaceFirst("").replace("  ", " "), value, variations));
                        }
                    } else {
                        Skript.error("unknown variation {" + m.group(1) + "}");
                    }
                } else {
                    r.put(name, value);
                }
            }
        }
        return r;
    }

    static int addAliases(String name, String value, HashMap<String, HashMap<String, ItemType>> variations) {
        ItemType t = Aliases.parseAlias(value);
        if (t == null) {
            return 0;
        }
        HashMap<String, ItemType> as = Aliases.getAliases(name, t, variations);
        boolean printedStartingWithNumberError = false;
        for (Map.Entry<String, ItemType> e : as.entrySet()) {
            String s = e.getKey().trim().replaceAll("\\s+", " ");
            String lc = s.toLowerCase();
            if (lc.matches("\\d+ .*")) {
                if (printedStartingWithNumberError) continue;
                Skript.error("aliases must not start with a number");
                printedStartingWithNumberError = true;
                continue;
            }
            aliases.put(lc, e.getValue());
            if (e.getValue().getTypes().size() != 1) continue;
            ItemData d = e.getValue().getTypes().get(0);
            MaterialName n = materialNames.get(d.getId());
            if (d.dataMin == -1 && d.dataMax == -1) {
                if (n != null) {
                    if (!n.name.equals("" + d.getId())) continue;
                    n.name = s;
                    continue;
                }
                materialNames.put(d.getId(), new MaterialName(d.getId(), s));
                continue;
            }
            if (n == null) {
                n = new MaterialName(d.getId(), "" + d.getId());
                materialNames.put(d.getId(), n);
            }
            n.names.put(new Pair<Short, Short>(d.dataMin, d.dataMax), s);
        }
        return as.size();
    }

    public static final String getMaterialName(int id, short data) {
        return Aliases.getMaterialName(id, data, data);
    }

    public static final String getDebugMaterialName(int id, short data) {
        return Aliases.getDebugMaterialName(id, data, data);
    }

    public static final String getMaterialName(int id, short dataMin, short dataMax) {
        MaterialName n = materialNames.get(id);
        if (n == null) {
            return "" + id;
        }
        return n.toString(dataMin, dataMax);
    }

    public static final String getDebugMaterialName(int id, short dataMin, short dataMax) {
        MaterialName n = materialNames.get(id);
        if (n == null) {
            return id + ":" + dataMin + (dataMax == dataMin ? "" : "-" + dataMax);
        }
        return n.getDebugMessage(dataMin, dataMax);
    }

    static final int addMissingMaterialNames() {
        Object m;
        int r = 0;
        StringBuilder missing = new StringBuilder("There are no aliases defined for the following ids: ");
        Material[] materialArray = Material.values();
        int n = materialArray.length;
        int n2 = 0;
        while (n2 < n) {
            m = materialArray[n2];
            if (materialNames.get(m.getId()) == null) {
                materialNames.put(m.getId(), new MaterialName(m.getId(), m.toString().toLowerCase().replace('_', ' ')));
                missing.append(String.valueOf(m.getId()) + ", ");
                ++r;
            }
            ++n2;
        }
        m = materialNames.get(-1);
        if (m == null) {
            materialNames.put(-1, new MaterialName(-1, "anything"));
            missing.append("<any>, ");
            ++r;
        }
        if (r > 0) {
            Skript.warning(missing.substring(0, missing.length() - 2));
        }
        return r;
    }

    public static ItemType parseAlias(String s) {
        String[] types;
        if (s == null || s.isEmpty()) {
            Skript.error("'' is not an item type");
            return null;
        }
        if (s.equals("*")) {
            return everything;
        }
        ItemType t = new ItemType();
        String[] stringArray = types = s.split("\\s*,\\s*");
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            if (Aliases.parseType(type, t) == null) {
                return null;
            }
            ++n2;
        }
        return t;
    }

    public static ItemType parseItemType(String s) {
        if (s == null || s.isEmpty()) {
            return null;
        }
        s = s.trim();
        String lc = s.toLowerCase();
        ItemType t = new ItemType();
        if (lc.matches("\\d+ of (all|every) .+")) {
            t.setAmount(Skript.parseInt(s.split(" ", 2)[0]));
            t.setAll(true);
            s = s.split(" ", 4)[3];
        } else if (lc.matches("\\d+ (of )?.+")) {
            t.setAmount(Skript.parseInt(s.split(" ", 2)[0]));
            s = s.matches("\\d+ of .+") ? s.split(" ", 3)[2] : s.split(" ", 2)[1];
        } else if (lc.startsWith("a ") || lc.startsWith("an ")) {
            t.setAmount(1);
            s = s.split(" ", 2)[1];
        } else if (lc.startsWith("all ") || lc.startsWith("every ")) {
            t.setAll(true);
            s = s.split(" ", 2)[1];
        }
        lc = s.toLowerCase();
        String of = Language.getSpaced("enchantments.of").toLowerCase();
        int c = -1;
        block0: while ((c = lc.indexOf(of, c + 1)) != -1) {
            String[] enchs;
            ItemType t2 = t.clone();
            SimpleLog log = SkriptLogger.startSubLog();
            if (Aliases.parseType(s.substring(0, c), t2) == null) {
                log.stop();
                continue;
            }
            log.stop();
            if (t2.numTypes() == 0) continue;
            HashMap<Enchantment, Integer> enchantments = new HashMap<Enchantment, Integer>();
            String[] stringArray = enchs = lc.substring(c + of.length(), lc.length()).split("\\s*(,|" + Language.get("and") + ")\\s*");
            int n = enchs.length;
            int n2 = 0;
            while (n2 < n) {
                String ench = stringArray[n2];
                EnchantmentType e = EnchantmentType.parse(ench);
                if (e == null) continue block0;
                enchantments.put(e.getType(), e.getLevel());
                ++n2;
            }
            t2.addEnchantments(enchantments);
            return t2;
        }
        if (Aliases.parseType(s, t) == null) {
            return null;
        }
        if (t.numTypes() == 0) {
            return null;
        }
        return t;
    }

    private static final ItemType parseType(String s, ItemType t) {
        int c = s.indexOf(58);
        if (c == -1) {
            c = s.length();
        }
        String type = s.substring(0, c);
        ItemData data = null;
        if (c != s.length() && (data = Aliases.parseData(s.substring(c + 1))) == null) {
            Skript.error("'" + s.substring(c) + "' is no a valid item data");
            return null;
        }
        if (type.isEmpty()) {
            t.add(data == null ? new ItemData() : data);
            return t;
        }
        if (type.matches("\\d+")) {
            ItemData d = new ItemData(Skript.parseInt(type));
            if (Material.getMaterial((int)d.getId()) == null) {
                Skript.error("There doesn't exist a material with id " + d.getId() + "!");
                return null;
            }
            if (data != null) {
                if (d.getId() <= 255 && (data.dataMax > 15 || data.dataMin > 15)) {
                    Skript.error("Blocks only have data values from 0 to 15");
                    return null;
                }
                d = d.intersection(data);
            }
            t.add(d);
            return t;
        }
        ItemType i = Aliases.getAlias(type, t.getAmount() == 1);
        if (i != null) {
            for (ItemData d : i) {
                if (data != null) {
                    if (d.getId() <= 255 && (data.dataMax > 15 || data.dataMin > 15)) {
                        Skript.error("Blocks only have data values from 0 to 15");
                        return null;
                    }
                    d = d.intersection(data);
                } else {
                    d = d.clone();
                }
                t.add(d);
            }
            return t;
        }
        Skript.error("'" + s + "' is not an item type");
        return null;
    }

    private static final ItemType getAlias(String s, boolean singular) {
        String lc = s.toLowerCase();
        ItemType i = Aliases.getAlias(lc);
        if (i != null) {
            return i.clone();
        }
        if (lc.startsWith("any ")) {
            return Aliases.getAlias(s.substring("any ".length()), true);
        }
        Pair<String, Boolean> p = Utils.getEnglishPlural(s);
        s = (String)p.first;
        lc = s.toLowerCase();
        if (lc.endsWith(" block")) {
            i = Aliases.getAlias(s.substring(0, s.length() - " block".length()), true);
            if (i != null) {
                int j = 0;
                while (j < i.numTypes()) {
                    ItemData d = i.getTypes().get(j);
                    if (d.getId() > 255) {
                        i.remove(d);
                        --j;
                    }
                    ++j;
                }
                if (i.getTypes().isEmpty()) {
                    return null;
                }
                return i;
            }
        } else if (lc.endsWith(" item") && (i = Aliases.getAlias(s.substring(0, s.length() - " item".length()), true)) != null) {
            int j = 0;
            while (j < i.numTypes()) {
                ItemData d = i.getTypes().get(j);
                if (d.getId() != -1 && d.getId() <= 255) {
                    i.remove(d);
                    --j;
                }
                ++j;
            }
            if (i.getTypes().isEmpty()) {
                return null;
            }
            return i;
        }
        return Aliases.getAlias(lc);
    }

    private static final ItemData parseData(String s) {
        if (s.isEmpty()) {
            return new ItemData();
        }
        if (!s.matches("\\d+(-\\d+)?")) {
            return null;
        }
        ItemData t = new ItemData();
        int i = s.indexOf(45);
        if (i == -1) {
            i = s.length();
        }
        try {
            t.dataMin = Short.parseShort(s.substring(0, i));
            t.dataMax = i == s.length() ? t.dataMin : Short.parseShort(s.substring(i + 1, s.length()));
        }
        catch (NumberFormatException e) {
            Skript.error("Item datas must be between 0 and 32767 (inclusive)");
            return null;
        }
        if (t.dataMax < t.dataMin) {
            Skript.error("The first number of a data range must be smaller than the second");
            return null;
        }
        return t;
    }

    public static void clear() {
        aliases.clear();
        materialNames.clear();
    }

    public static void load() {
        try {
            aliasConfig = new Config(new File(Skript.getInstance().getDataFolder(), "aliases.sk"), false, true, "=");
        }
        catch (IOException e) {
            Skript.error("Could not load the aliases config: " + e.getLocalizedMessage());
            return;
        }
        final ArrayList aliasNodes = new ArrayList();
        new SectionValidator().addEntry("aliases", new Setter<String>(){

            @Override
            public void set(String s) {
                String[] stringArray = s.split(",");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String n3 = stringArray[n2];
                    aliasNodes.add(n3.trim());
                    ++n2;
                }
            }
        }, false).setAllowUndefinedSections(true).validate(aliasConfig.getMainNode());
        for (Node node : aliasConfig.getMainNode()) {
            if (!(node instanceof SectionNode) || aliasNodes.contains(node.getName())) continue;
            Skript.error("Invalid section '" + node.getName() + "'. If this is an alias section add it to 'aliases' so it will be loaded.");
        }
        HashMap<String, HashMap<String, ItemType>> variations = new HashMap<String, HashMap<String, ItemType>>();
        int num = 0;
        for (String an : aliasNodes) {
            Node node = aliasConfig.getMainNode().get(an);
            SkriptLogger.setNode(node);
            if (node == null) {
                Skript.error("alias section '" + an + "' not found!");
                continue;
            }
            if (!(node instanceof SectionNode)) {
                Skript.error("aliases have to be in sections, but '" + an + "' is not a section!");
                continue;
            }
            int i = 0;
            for (Node n : (SectionNode)node) {
                if (n instanceof EntryNode) {
                    i += Aliases.addAliases(((EntryNode)n).getKey(), ((EntryNode)n).getValue(), variations);
                    continue;
                }
                if (!(n instanceof SectionNode)) continue;
                if (!n.getName().startsWith("{") || !n.getName().endsWith("}")) {
                    Skript.error("unexpected non-variation section");
                    continue;
                }
                HashMap<String, ItemType> vs = new HashMap<String, ItemType>();
                for (Node a : (SectionNode)n) {
                    if (a instanceof SectionNode) {
                        Skript.error("unexpected section");
                        continue;
                    }
                    ItemType t = Aliases.parseAlias(((EntryNode)a).getValue());
                    if (t == null) continue;
                    vs.put(((EntryNode)a).getKey(), t);
                }
                variations.put(n.getName().substring(1, n.getName().length() - 1), vs);
            }
            if (Skript.logHigh()) {
                Skript.info("loaded " + i + " alias" + (i == 1 ? "" : "es") + " from " + node.getName());
            }
            num += i;
        }
        SkriptLogger.setNode(null);
        if (Skript.logNormal()) {
            Skript.info("loaded a total of " + num + " aliases");
        }
        Aliases.addMissingMaterialNames();
        if (!SkriptConfig.keepConfigsLoaded) {
            aliasConfig = null;
        }
    }

    private static final class MaterialName {
        private String name;
        private final int id;
        private final HashMap<Pair<Short, Short>, String> names = new HashMap();

        public MaterialName(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public String toString(short dataMin, short dataMax) {
            if (this.names == null) {
                return this.name;
            }
            String s = this.names.get(new Pair<Short, Short>(dataMin, dataMax));
            if (s != null) {
                return s;
            }
            if (dataMin == -1 && dataMax == -1 || dataMin == 0 && dataMax == 0) {
                return this.name;
            }
            s = this.names.get(new Pair<Short, Short>((short)-1, (short)-1));
            if (s != null) {
                return s;
            }
            return this.name;
        }

        public String getDebugMessage(short dataMin, short dataMax) {
            if (this.names == null) {
                return this.name;
            }
            String s = this.names.get(new Pair<Short, Short>(dataMin, dataMax));
            if (s != null) {
                return s;
            }
            if (dataMin == -1 && dataMax == -1 || dataMin == 0 && dataMax == 0) {
                return this.name;
            }
            return String.valueOf(this.name) + ":" + (dataMin == -1 ? (short)0 : dataMin) + (dataMin == dataMax ? "" : "-" + (dataMax == -1 ? (this.id <= 255 ? (short)15 : Short.MAX_VALUE) : dataMax));
        }
    }
}

