/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util;

import ch.njol.skript.localization.Language;
import ch.njol.skript.util.BlockUtils;
import ch.njol.skript.util.Container;
import ch.njol.skript.util.ItemData;
import ch.njol.skript.util.Utils;
import ch.njol.util.iterator.SingleItemIterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

@Container.ContainerType(value=ItemStack.class)
public class ItemType
implements Serializable,
Cloneable,
Iterable<ItemData>,
Container<ItemStack> {
    private static final long serialVersionUID = 2512697660905031169L;
    private final ArrayList<ItemData> types = new ArrayList();
    private boolean all = false;
    private int amount = -1;
    private boolean hasPreferred = false;
    private int numItems = 0;
    private transient Map<Enchantment, Integer> enchantments = null;
    private static final int[][] preferredMaterials = new int[][]{{Material.STATIONARY_WATER.getId(), Material.WATER.getId()}, {Material.STATIONARY_LAVA.getId(), Material.LAVA.getId()}, {Material.BED.getId(), Material.BED_BLOCK.getId()}, {Material.BREWING_STAND_ITEM.getId(), Material.BREWING_STAND.getId()}, {Material.REDSTONE_LAMP_OFF.getId(), Material.REDSTONE_LAMP_ON.getId()}, {Material.REDSTONE_TORCH_ON.getId(), Material.REDSTONE_TORCH_OFF.getId()}, {Material.REDSTONE_ORE.getId(), Material.GLOWING_REDSTONE_ORE.getId()}, {Material.FURNACE.getId(), Material.BURNING_FURNACE.getId()}, {Material.CAULDRON_ITEM.getId(), Material.CAULDRON.getId()}, {Material.SEEDS.getId(), Material.CROPS.getId()}, {Material.DIODE.getId(), Material.DIODE_BLOCK_OFF.getId(), Material.DIODE_BLOCK_ON.getId()}, {Material.DIODE_BLOCK_OFF.getId(), Material.DIODE_BLOCK_ON.getId()}, {Material.SUGAR_CANE.getId(), Material.SUGAR_CANE_BLOCK.getId()}, {Material.SIGN.getId(), Material.SIGN_POST.getId(), Material.WALL_SIGN.getId()}, {Material.CAKE.getId(), Material.CAKE_BLOCK.getId()}, {140, 390}, {141, 391}, {142, 392}, {144, 387}, {Material.PISTON_BASE.getId(), Material.PISTON_EXTENSION.getId()}, {Material.PISTON_STICKY_BASE.getId(), Material.PISTON_EXTENSION.getId()}};
    private ItemType item = null;
    private ItemType block = null;
    private static final Random random = new Random();

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        if (this.enchantments == null) {
            out.writeObject(null);
        } else {
            Integer[][] enchs = new Integer[this.enchantments.size()][];
            int i = 0;
            for (Map.Entry<Enchantment, Integer> e : this.enchantments.entrySet()) {
                enchs[i] = new Integer[]{e.getKey().getId(), e.getValue()};
                ++i;
            }
            out.writeObject(enchs);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        Object o = in.readObject();
        if (o == null) {
            return;
        }
        Integer[][] enchs = (Integer[][])o;
        this.enchantments = new HashMap<Enchantment, Integer>(enchs.length);
        Integer[][] integerArray = enchs;
        int n = enchs.length;
        int n2 = 0;
        while (n2 < n) {
            Integer[] e = integerArray[n2];
            this.enchantments.put(Enchantment.getById((int)e[0]), e[1]);
            ++n2;
        }
    }

    public ItemType() {
    }

    public ItemType(ItemStack i) {
        this.amount = i.getAmount();
        this.add(new ItemData(i));
        if (!i.getEnchantments().isEmpty()) {
            this.enchantments = new HashMap<Enchantment, Integer>(i.getEnchantments());
        }
    }

    public ItemType(Block block) {
        this.amount = 1;
        this.add(new ItemData(block.getTypeId(), block.getData()));
    }

    public ItemType(ItemType i) {
        this.all = i.all;
        this.amount = i.amount;
        this.hasPreferred = i.hasPreferred;
        this.numItems = i.numItems;
        this.block = i.block == null ? null : i.block.clone();
        this.item = i.item == null ? null : i.item.clone();
        for (ItemData d : i) {
            this.types.add(d.clone());
        }
        if (i.enchantments != null) {
            this.enchantments = new HashMap<Enchantment, Integer>(i.enchantments);
        }
    }

    public void modified() {
        this.block = null;
        this.item = null;
        this.checkHasPreferred();
    }

    public int getAmount() {
        return this.amount == -1 ? 1 : this.amount;
    }

    public int getInternalAmount() {
        return this.amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    public boolean isAll() {
        return this.all;
    }

    public void setAll(boolean all) {
        this.all = all;
    }

    public boolean isOfType(ItemStack item) {
        if (item == null) {
            return this.isOfType(0, (short)0);
        }
        if (this.enchantments != null && !this.enchantments.equals(item.getEnchantments())) {
            return false;
        }
        return this.isOfType(item.getTypeId(), item.getDurability());
    }

    public boolean isOfType(Block block) {
        if (block == null || this.enchantments != null) {
            return false;
        }
        return this.isOfType(block.getTypeId(), block.getData());
    }

    public boolean isOfType(int id, short data) {
        for (ItemData type : this.types) {
            if (!type.isOfType(id, data)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.toString(false);
    }

    private String toString(boolean debug) {
        StringBuilder b = new StringBuilder();
        if (this.types.size() == 1 && !this.types.get(0).hasDataRange()) {
            if (this.getAmount() != 1) {
                b.append(String.valueOf(this.amount) + " ");
            }
            if (this.isAll()) {
                b.append(this.getAmount() == 1 ? "every " : "of every ");
            }
        } else {
            if (this.getAmount() != 1) {
                b.append(String.valueOf(this.amount) + " of ");
            }
            b.append(this.isAll() ? "every " : "any ");
        }
        int i = 0;
        while (i < this.types.size()) {
            if (i != 0) {
                if (i == this.types.size() - 1) {
                    b.append(this.isAll() ? " and " : " or ");
                } else {
                    b.append(", ");
                }
            }
            String p = this.types.get(i).toString(debug);
            b.append(this.amount > 1 ? Utils.toPlural(p) : p);
            ++i;
        }
        if (this.enchantments == null) {
            return b.toString();
        }
        b.append(Language.getSpaced("enchantments.of"));
        i = 0;
        for (Map.Entry<Enchantment, Integer> e : this.enchantments.entrySet()) {
            if (i != 0) {
                if (i != this.enchantments.size() - 1) {
                    b.append(", ");
                } else {
                    b.append(Language.getSpaced("and"));
                }
            }
            b.append(Language.get("enchantments.names." + e.getKey().getName()));
            b.append(" ");
            b.append(e.getValue());
            ++i;
        }
        return b.toString();
    }

    public static String toString(ItemStack i) {
        return new ItemType(i).toString();
    }

    public String getDebugMessage() {
        return this.toString(true);
    }

    public ItemType getItem() {
        if (this.item != null) {
            return this.item;
        }
        if (!this.hasPreferred || this.all) {
            return this;
        }
        this.item = this.clone();
        int i = 0;
        while (i < this.item.types.size()) {
            ItemData d = this.item.types.get(i);
            int[][] nArray = preferredMaterials;
            int n = preferredMaterials.length;
            int n2 = 0;
            while (n2 < n) {
                int[] p = nArray[n2];
                if (p[1] == Material.PISTON_EXTENSION.getId()) {
                    if (d.typeid != Material.PISTON_EXTENSION.getId()) break;
                    boolean hasBase = false;
                    for (ItemData t : this.types) {
                        if (t.typeid != Material.PISTON_BASE.getId() && t.typeid != Material.PISTON_STICKY_BASE.getId()) continue;
                        hasBase = true;
                        break;
                    }
                    if (!hasBase) break;
                    this.item.numItems -= d.numItems();
                    this.item.types.remove(i--);
                    break;
                }
                if (Utils.indexOf(p, d.typeid, 1) != -1) {
                    ItemData c = d.clone();
                    c.typeid = p[0];
                    if (!this.item.types.contains(c)) break;
                    this.item.numItems -= d.numItems();
                    this.item.types.remove(i--);
                    break;
                }
                ++n2;
            }
            ++i;
        }
        this.item.hasPreferred = false;
        return this.item;
    }

    public ItemType getBlock() {
        if (this.block != null) {
            return this.block;
        }
        if (!this.hasPreferred || this.all) {
            return this;
        }
        this.block = this.clone();
        int i = 0;
        while (i < this.block.types.size()) {
            ItemData d = this.block.types.get(i);
            int[][] nArray = preferredMaterials;
            int n = preferredMaterials.length;
            int n2 = 0;
            while (n2 < n) {
                int[] p = nArray[n2];
                if (p[1] == Material.PISTON_EXTENSION.getId()) {
                    if (d.typeid != Material.PISTON_EXTENSION.getId()) break;
                    boolean hasBase = false;
                    for (ItemData t : this.types) {
                        if (t.typeid != Material.PISTON_BASE.getId() && t.typeid != Material.PISTON_STICKY_BASE.getId()) continue;
                        hasBase = true;
                        break;
                    }
                    if (!hasBase) break;
                    this.item.numItems -= d.numItems();
                    this.item.types.remove(i--);
                    break;
                }
                if (p[0] <= 255 && Utils.indexOf(p, d.typeid, 1) != -1) {
                    ItemData c = d.clone();
                    c.typeid = p[0];
                    if (!this.block.types.contains(c)) break;
                    this.block.numItems -= d.numItems();
                    this.block.types.remove(i--);
                    break;
                }
                if (d.typeid == p[0]) {
                    ItemData c = d.clone();
                    c.typeid = p[1];
                    if (!this.block.types.contains(c)) break;
                    this.block.numItems -= d.numItems();
                    this.block.types.remove(i--);
                    break;
                }
                ++n2;
            }
            ++i;
        }
        this.block.hasPreferred = false;
        return this.block;
    }

    private void checkHasPreferred() {
        int[][] nArray = preferredMaterials;
        int n = preferredMaterials.length;
        int n2 = 0;
        while (n2 < n) {
            int[] p = nArray[n2];
            int c = -1;
            for (ItemData d : this.types) {
                if (c != -1 && Utils.indexOf(p, d.typeid) != -1) {
                    this.hasPreferred = true;
                    return;
                }
                if (c != -1) continue;
                c = Utils.indexOf(p, d.typeid);
            }
            ++n2;
        }
        this.hasPreferred = false;
    }

    public boolean setBlock(Block block, boolean applyPhysics) {
        for (ItemData d : this.types) {
            if (d.typeid > 255 || !BlockUtils.set(block, d.typeid, (byte)d.dataMin, (byte)d.dataMax, applyPhysics)) continue;
            return true;
        }
        return false;
    }

    public ItemType intersection(ItemType other) {
        if (this.amount != -1 || other.amount != -1 || this.enchantments != null || other.enchantments != null) {
            throw new IllegalStateException("ItemType.intersection(ItemType) must only be used to instersect aliases");
        }
        ItemType r = new ItemType();
        for (ItemData d1 : this.types) {
            for (ItemData d2 : other.types) {
                r.add(d1.intersection(d2));
            }
        }
        if (r.types.isEmpty()) {
            return null;
        }
        return r;
    }

    public void add(ItemData type) {
        if (type != null) {
            this.types.add(type);
            this.numItems += type.numItems();
            this.modified();
        }
    }

    public void addAll(Collection<ItemData> types) {
        for (ItemData type : types) {
            if (type == null) continue;
            this.types.add(type);
            this.numItems += type.numItems();
        }
        this.modified();
    }

    public void remove(ItemData type) {
        if (this.types.remove(type)) {
            this.numItems -= type.numItems();
            this.modified();
        }
    }

    public void addEnchantment(Enchantment e, int level) {
        if (this.enchantments == null) {
            this.enchantments = new HashMap<Enchantment, Integer>();
        }
        this.enchantments.put(e, level);
    }

    public void addEnchantments(Map<Enchantment, Integer> enchantments) {
        if (this.enchantments == null) {
            this.enchantments = new HashMap<Enchantment, Integer>(enchantments);
        } else {
            this.enchantments.putAll(enchantments);
        }
    }

    public void emptyEnchantments() {
        this.enchantments = new HashMap<Enchantment, Integer>(0);
    }

    public Map<Enchantment, Integer> getEnchantments() {
        return this.enchantments;
    }

    @Override
    public Iterator<ItemStack> containerIterator() {
        return new Iterator<ItemStack>(){
            Iterator<ItemData> iter;
            Iterator<ItemStack> currentDataIter;
            {
                this.iter = ItemType.this.types.iterator();
            }

            @Override
            public boolean hasNext() {
                while (this.iter.hasNext() && (this.currentDataIter == null || !this.currentDataIter.hasNext())) {
                    this.currentDataIter = this.iter.next().getAll();
                }
                return this.currentDataIter != null && this.currentDataIter.hasNext();
            }

            @Override
            public ItemStack next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ItemStack is = this.currentDataIter.next();
                is.setAmount(ItemType.this.getAmount());
                if (ItemType.this.enchantments != null) {
                    is.addUnsafeEnchantments(ItemType.this.enchantments);
                }
                return is;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Iterable<ItemStack> getAll() {
        if (!this.isAll()) {
            final ItemStack i = this.getRandom();
            return new Iterable<ItemStack>(){

                @Override
                public Iterator<ItemStack> iterator() {
                    return new SingleItemIterator<ItemStack>(i);
                }
            };
        }
        return new Iterable<ItemStack>(){

            @Override
            public Iterator<ItemStack> iterator() {
                return ItemType.this.containerIterator();
            }
        };
    }

    public ItemStack removeFrom(ItemStack item) {
        if (item == null) {
            return null;
        }
        if (this.enchantments != null && !this.enchantments.equals(item.getEnchantments())) {
            return item;
        }
        for (ItemData type : this.types) {
            if (!type.isOfType(item)) continue;
            item.setAmount(Math.max(item.getAmount() - this.getAmount(), 0));
        }
        return item;
    }

    public ItemStack addTo(ItemStack item) {
        if (item == null || item.getTypeId() == 0) {
            return this.getRandom();
        }
        if (this.enchantments != null && !this.enchantments.equals(item.getEnchantments())) {
            return item;
        }
        for (ItemData type : this.types) {
            if (!type.isOfType(item)) continue;
            item.setAmount(Math.min(item.getAmount() + this.getAmount(), item.getMaxStackSize()));
            return item;
        }
        return item;
    }

    public ItemType clone() {
        return new ItemType(this);
    }

    public ItemStack getRandom() {
        if (this.numItems == 0) {
            return null;
        }
        int item = random.nextInt(this.numItems);
        int i = -1;
        while (item >= 0) {
            item -= this.types.get(++i).numItems();
        }
        ItemStack is = this.types.get(i).getRandom();
        is.setAmount(this.getAmount());
        if (this.enchantments != null) {
            is.addUnsafeEnchantments(this.enchantments);
        }
        return is;
    }

    public boolean hasSpace(Inventory invi) {
        if (!this.isAll() && (this.getItem().types.size() != 1 || this.getItem().types.get(0).hasDataRange() || this.getItem().types.get((int)0).typeid == -1)) {
            return false;
        }
        return this.addTo(ItemType.getCopiedContents(invi));
    }

    public static final ItemStack[] getCopiedContents(Inventory invi) {
        ItemStack[] buf = invi.getContents();
        int i = 0;
        while (i < buf.length) {
            if (buf[i] != null) {
                buf[i] = buf[i].clone();
            }
            ++i;
        }
        return buf;
    }

    public List<ItemData> getTypes() {
        return Collections.unmodifiableList(this.types);
    }

    public int numTypes() {
        return this.types.size();
    }

    public int numItems() {
        return this.numItems;
    }

    @Override
    public Iterator<ItemData> iterator() {
        return Collections.unmodifiableList(this.types).iterator();
    }

    public boolean isContainedIn(Inventory invi) {
        return this.isContainedIn(invi.getContents());
    }

    public boolean isContainedIn(ItemStack[] list) {
        for (ItemData d : this.types) {
            int found = 0;
            ItemStack[] itemStackArray = list;
            int n = list.length;
            int n2 = 0;
            while (n2 < n) {
                ItemStack i = itemStackArray[n2];
                if (d.isOfType(i) && (this.enchantments == null || this.enchantments.equals(i.getEnchantments())) && (found += i == null ? 1 : i.getAmount()) >= this.getAmount()) {
                    if (this.all) break;
                    return true;
                }
                ++n2;
            }
            if (!this.all || found >= this.getAmount()) continue;
            return false;
        }
        return this.all;
    }

    public boolean removeFrom(Inventory invi) {
        ItemStack[] buf = invi.getContents();
        boolean isPlayerInvi = invi instanceof PlayerInventory;
        ItemStack[] armour = isPlayerInvi ? ((PlayerInventory)invi).getArmorContents() : null;
        boolean ok = this.removeFrom(Arrays.asList(buf), armour == null ? null : Arrays.asList(armour));
        invi.setContents(buf);
        if (isPlayerInvi) {
            ((PlayerInventory)invi).setArmorContents(armour);
        }
        return ok;
    }

    public boolean removeFrom(List<ItemStack> ... lists) {
        int removed = 0;
        boolean ok = true;
        for (ItemData d : this.types) {
            if (this.all) {
                removed = 0;
            }
            List<ItemStack>[] listArray = lists;
            int n = lists.length;
            int n2 = 0;
            while (n2 < n) {
                List<ItemStack> list = listArray[n2];
                if (list != null) {
                    int i = 0;
                    while (i < list.size()) {
                        ItemStack is = list.get(i);
                        if (is != null && d.isOfType(is) && (this.enchantments == null || this.enchantments.equals(is.getEnchantments()))) {
                            if (this.all && this.amount == -1) {
                                list.set(i, null);
                                removed = 1;
                            } else {
                                int toRemove = Math.min(is.getAmount(), this.getAmount() - removed);
                                removed += toRemove;
                                if (toRemove == is.getAmount()) {
                                    list.set(i, null);
                                } else {
                                    is.setAmount(is.getAmount() - toRemove);
                                }
                                if (removed == this.getAmount()) {
                                    if (this.all) break;
                                    return true;
                                }
                            }
                        }
                        ++i;
                    }
                }
                ++n2;
            }
            if (!this.all) continue;
            ok &= removed == this.getAmount();
        }
        if (!this.all) {
            return false;
        }
        return ok;
    }

    public void addTo(List<ItemStack> list) {
        if (!this.isAll()) {
            list.add(this.getItem().getRandom());
            return;
        }
        for (ItemStack is : this.getItem().getAll()) {
            list.add(is);
        }
    }

    public boolean addTo(Inventory invi) {
        ItemStack[] buf = invi.getContents();
        boolean b = this.addTo(buf);
        invi.setContents(buf);
        return b;
    }

    private static boolean addTo(ItemStack is, ItemStack[] buf) {
        int toAdd;
        if (is == null || is.getTypeId() == 0) {
            return true;
        }
        int added = 0;
        int i = 0;
        while (i < buf.length) {
            if (Utils.itemStacksEqual(is, buf[i])) {
                toAdd = Math.min(buf[i].getMaxStackSize() - buf[i].getAmount(), is.getAmount() - added);
                buf[i].setAmount(buf[i].getAmount() + toAdd);
                if ((added += toAdd) == is.getAmount()) {
                    return true;
                }
            }
            ++i;
        }
        i = 0;
        while (i < buf.length) {
            if (buf[i] == null) {
                toAdd = Math.min(is.getMaxStackSize(), is.getAmount() - added);
                buf[i] = is.clone();
                buf[i].setAmount(toAdd);
                if ((added += toAdd) == is.getAmount()) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    public boolean addTo(ItemStack[] buf) {
        if (!this.isAll()) {
            return ItemType.addTo(this.getItem().getRandom(), buf);
        }
        boolean ok = true;
        for (ItemStack is : this.getItem().getAll()) {
            ok &= ItemType.addTo(is, buf);
        }
        return ok;
    }
}

