/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util;

import ch.njol.skript.localization.Language;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.DyeColor;

public enum Color {
    BLACK(DyeColor.BLACK, ChatColor.BLACK),
    DARK_GREY(DyeColor.GRAY, ChatColor.DARK_GRAY),
    LIGHT_GREY(DyeColor.SILVER, ChatColor.GRAY),
    WHITE(DyeColor.WHITE, ChatColor.WHITE),
    DARK_BLUE(DyeColor.BLUE, ChatColor.DARK_BLUE),
    BROWN(DyeColor.BROWN, ChatColor.BLUE),
    DARK_CYAN(DyeColor.CYAN, ChatColor.DARK_AQUA),
    LIGHT_CYAN(DyeColor.LIGHT_BLUE, ChatColor.AQUA),
    DARK_GREEN(DyeColor.GREEN, ChatColor.DARK_GREEN),
    LIGHT_GREEN(DyeColor.LIME, ChatColor.GREEN),
    YELLOW(DyeColor.YELLOW, ChatColor.YELLOW),
    ORANGE(DyeColor.ORANGE, ChatColor.GOLD),
    DARK_RED(DyeColor.RED, ChatColor.DARK_RED),
    LIGHT_RED(DyeColor.PINK, ChatColor.RED),
    DARK_PURPLE(DyeColor.PURPLE, ChatColor.DARK_PURPLE),
    LIGHT_PURPLE(DyeColor.MAGENTA, ChatColor.LIGHT_PURPLE);

    private final DyeColor wool;
    private final ChatColor chat;
    private String[] names = null;
    private static final Color[] byWool;
    private static final Map<String, Color> byName;

    static {
        byWool = new Color[16];
        Color[] colorArray = Color.values();
        int n = colorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Color c;
            Color.byWool[c.wool.getData()] = c = colorArray[n2];
            ++n2;
        }
        byName = new HashMap<String, Color>();
        Language.addListener(new Language.LanguageChangeListener(){

            @Override
            public void onLanguageChange() {
                byName.clear();
                Color[] colorArray = Color.values();
                int n = colorArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Color c = colorArray[n2];
                    c.names = Language.getList("colors." + c.name());
                    String[] stringArray = c.names;
                    int n3 = stringArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String name = stringArray[n4];
                        byName.put(name.toLowerCase(), c);
                        ++n4;
                    }
                    ++n2;
                }
            }
        });
    }

    private Color(DyeColor wool, ChatColor chat) {
        this.wool = wool;
        this.chat = chat;
    }

    public byte getDye() {
        return (byte)(15 - this.wool.getData());
    }

    public DyeColor getWoolColor() {
        return this.wool;
    }

    public byte getWool() {
        return this.wool.getData();
    }

    public String getChat() {
        return this.chat.toString();
    }

    public String toString() {
        return this.names[0];
    }

    public static final Color byName(String name) {
        return byName.get(name.toLowerCase());
    }

    public static final Color byWool(short data) {
        if (data < 0 || data >= 16) {
            return null;
        }
        return byWool[data];
    }

    public static final Color byDye(short data) {
        if (data < 0 || data >= 16) {
            return null;
        }
        return byWool[15 - data];
    }
}

