/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.localization;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAddon;
import ch.njol.skript.config.Config;
import ch.njol.skript.util.Version;
import ch.njol.util.ExceptionUtils;
import ch.njol.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import org.bukkit.plugin.Plugin;

public class Language {
    private static String name = "english";
    private static HashMap<String, String> english = new HashMap();
    private static HashMap<String, String> englishPlurals = new HashMap();
    private static HashMap<String, String> localized;
    private static HashMap<String, String> localizedPlurals;
    private static boolean useLocal;
    private static HashMap<Plugin, Version> langVersion;
    private static final Pattern split;
    private static final Collection<LanguageChangeListener> listeners;

    static {
        useLocal = false;
        langVersion = new HashMap();
        split = Pattern.compile("\\s*,\\s*");
        listeners = new ArrayList<LanguageChangeListener>();
    }

    public static String getName() {
        return name;
    }

    private static final String get_i(String key) {
        String s;
        if (useLocal && localized != null && (s = localized.get(key)) != null) {
            return s;
        }
        return english.get(key);
    }

    public static String get(String key) {
        String s = Language.get_i(key.toLowerCase(Locale.ENGLISH));
        if (s == null) {
            return key.toLowerCase(Locale.ENGLISH);
        }
        return s;
    }

    public static String getPlural(String key) {
        String s;
        if (useLocal && localized != null) {
            s = localizedPlurals.get(key);
            if (s != null) {
                return s;
            }
            s = localized.get(key);
            if (s != null) {
                return s;
            }
        }
        if ((s = englishPlurals.get(key)) != null) {
            return s;
        }
        s = english.get(key);
        if (s != null) {
            return s;
        }
        return key;
    }

    public static String get(String key, boolean plural) {
        return plural ? Language.getPlural(key) : Language.get(key);
    }

    public static String format(String key, Object ... args) {
        String value = Language.get_i(key = key.toLowerCase(Locale.ENGLISH));
        if (value == null) {
            return key;
        }
        try {
            return String.format(value, args);
        }
        catch (Exception e) {
            return key;
        }
    }

    public static String getSpaced(String key) {
        String s = Language.get(key.toLowerCase(Locale.ENGLISH));
        if (s.isEmpty()) {
            return " ";
        }
        return " " + s + " ";
    }

    public static String[] getList(String key) {
        String s = Language.get_i(key.toLowerCase(Locale.ENGLISH));
        if (s == null) {
            return new String[]{key.toLowerCase(Locale.ENGLISH)};
        }
        return split.split(s);
    }

    public static boolean keyExists(String key) {
        return english.containsKey(key);
    }

    public static void loadDefault(SkriptAddon addon) {
        HashMap<String, String> en;
        if (addon.getLanguageFileDirectory() == null) {
            return;
        }
        InputStream din = addon.plugin.getResource(String.valueOf(addon.getLanguageFileDirectory()) + "/english.lang");
        if (din == null) {
            throw new IllegalStateException(String.valueOf(addon.getFile().getName()) + " is missing the required english.lang file!");
        }
        try {
            try {
                en = new Config(din, "english.lang", false, false, ":").toMap(".");
            }
            catch (Exception e) {
                throw Skript.exception(e, "Could not load " + addon.name + "'s default language file!");
            }
        }
        finally {
            try {
                din.close();
            }
            catch (IOException iOException) {}
        }
        langVersion.put((Plugin)addon.plugin, new Version(en.get("version")));
        en.remove("version");
        Language.makePlurals(en, englishPlurals);
        english.putAll(en);
        for (LanguageChangeListener l : listeners) {
            l.onLanguageChange();
        }
    }

    public static boolean load(String name) {
        name = name.toLowerCase();
        localizedPlurals = new HashMap();
        boolean exists = Language.load(Skript.getAddonInstance(), name);
        for (SkriptAddon addon : Skript.getAddons()) {
            exists |= Language.load(addon, name);
        }
        if (!exists) {
            return false;
        }
        Language.name = name;
        Language.validateLocalized();
        if (useLocal) {
            for (LanguageChangeListener l : listeners) {
                l.onLanguageChange();
            }
        }
        return true;
    }

    private static boolean load(SkriptAddon addon, String name) {
        HashMap<String, String> l;
        block10: {
            if (addon.getLanguageFileDirectory() == null) {
                return false;
            }
            l = Language.load(addon.plugin.getResource(String.valueOf(addon.getLanguageFileDirectory()) + "/" + name + ".lang"), name);
            File f = new File(addon.plugin.getDataFolder(), String.valueOf(addon.getLanguageFileDirectory()) + File.separator + name + ".lang");
            try {
                if (f.exists()) {
                    l.putAll(Language.load(new FileInputStream(f), name));
                }
            }
            catch (FileNotFoundException e) {
                if ($assertionsDisabled) break block10;
                throw new AssertionError();
            }
        }
        if (l.isEmpty()) {
            return false;
        }
        if (!l.containsKey("version")) {
            Skript.error(String.valueOf(addon.name) + "'s language file " + name + ".lang does not provide a version number!");
        } else {
            try {
                Version v = new Version(l.get("version"));
                if (v.isSmallerThan(langVersion.get(addon.plugin))) {
                    Skript.warning(String.valueOf(addon.name) + "'s language file " + name + ".lang is outdated, some messages will be english.");
                }
            }
            catch (IllegalArgumentException e) {
                Skript.error("Illegal version syntax in " + addon.name + "'s language file " + name + ".lang: " + e.getLocalizedMessage());
            }
        }
        l.remove("version");
        Language.makePlurals(l, localizedPlurals);
        localized.putAll(l);
        return true;
    }

    private static HashMap<String, String> load(InputStream in, String name) {
        if (in == null) {
            return new HashMap<String, String>();
        }
        try {
            HashMap<String, String> hashMap = new Config(in, String.valueOf(name) + ".lang", false, false, ":").toMap(".");
            return hashMap;
        }
        catch (IOException e) {
            Skript.exception(e, "Could not load the language file '" + name + ".lang': " + ExceptionUtils.toString(e));
            HashMap<String, String> hashMap = new HashMap<String, String>();
            return hashMap;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static final void makePlurals(HashMap<String, String> lang, HashMap<String, String> plurals) {
        for (Map.Entry<String, String> e : lang.entrySet()) {
            String s = e.getValue();
            int c = s.indexOf("\u00a6");
            if (c == -1) continue;
            int c2 = s.indexOf("\u00a6", c + 1);
            if (c2 == -1) {
                e.setValue(s.substring(0, c));
            } else {
                e.setValue(String.valueOf(s.substring(0, c)) + s.substring(c + 1, c2));
            }
            plurals.put(e.getKey(), String.valueOf(s.substring(0, c)) + s.substring((c2 == -1 ? c : c2) + 1));
        }
    }

    private static void validateLocalized() {
        HashSet<String> s = new HashSet<String>(english.keySet());
        s.removeAll(localized.keySet());
        if (!s.isEmpty() && Skript.logNormal()) {
            Skript.error(String.valueOf(name) + ".lang is missing the following entries: " + StringUtils.join(s));
        }
        s = new HashSet<String>(localized.keySet());
        s.removeAll(english.keySet());
        if (!s.isEmpty() && Skript.logHigh()) {
            Skript.warning(String.valueOf(name) + ".lang has superfluous entries: " + StringUtils.join(s));
        }
    }

    public void addDefaults(Map<String, String> m) {
        english.putAll(m);
    }

    public static void addListener(LanguageChangeListener l) {
        listeners.add(l);
        if (english != null) {
            l.onLanguageChange();
        }
    }

    public static void setUseLocal(boolean b) {
        if (useLocal == b) {
            return;
        }
        useLocal = b;
        for (LanguageChangeListener l : listeners) {
            l.onLanguageChange();
        }
    }

    public static interface LanguageChangeListener {
        public void onLanguageChange();
    }
}

