/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang.util;

import ch.njol.skript.SkriptAPIException;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.util.ConvertedExpression;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.Utils;
import ch.njol.util.Checker;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import org.bukkit.event.Event;

public class ConvertedLiteral<F, T>
extends ConvertedExpression<F, T>
implements Literal<T> {
    private static final long serialVersionUID = 2640112540190230558L;
    protected transient T[] data;

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        String codeName = Classes.getExactClassName(this.data.getClass().getComponentType());
        if (codeName == null) {
            throw new SkriptAPIException(String.valueOf(this.data.getClass().getComponentType().getName()) + " is not registered");
        }
        out.writeUTF(codeName);
        String[][] d = new String[this.data.length][];
        int i = 0;
        while (i < this.data.length) {
            d[i] = Classes.serialize(this.data[i]);
            if (d[i] == null) {
                throw new SkriptAPIException("Parsed class cannot be serialized: " + this.data[i].getClass().getName());
            }
            ++i;
        }
        out.writeObject(d);
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        String codeName = in.readUTF();
        String[][] d = (String[][])in.readObject();
        ClassInfo<?> ci = Classes.getClassInfo(codeName);
        this.data = (Object[])Array.newInstance(ci.getC(), d.length);
        int i = 0;
        while (i < this.data.length) {
            this.data[i] = Classes.deserialize(d[i][0], d[i][1]);
            ++i;
        }
    }

    public ConvertedLiteral(Literal<F> source, T[] data, Class<T> to) {
        super(source, to, null);
        this.data = data;
    }

    @Override
    public <R> Literal<? extends R> getConvertedExpression(Class<R> to) {
        if (to.isAssignableFrom(this.to)) {
            return this;
        }
        return ((Literal)this.source).getConvertedExpression(to);
    }

    @Override
    public String toString(Event e, boolean debug) {
        return Classes.toString(this.data, this.getAnd());
    }

    @Override
    public T[] getArray() {
        return this.data;
    }

    @Override
    public T[] getAll() {
        return this.data;
    }

    @Override
    public T[] getArray(Event e) {
        return this.getArray();
    }

    @Override
    public T getSingle() {
        if (this.getAnd() && this.data.length > 1) {
            throw new SkriptAPIException("Call to getSingle on a non-single expression");
        }
        return Utils.random(this.data);
    }

    @Override
    public T getSingle(Event e) {
        return this.getSingle();
    }

    @Override
    public boolean check(Event e, Checker<? super T> c) {
        return SimpleExpression.check(this.data, c, false, this.getAnd());
    }

    @Override
    public boolean check(Event e, Checker<? super T> c, boolean negated) {
        return SimpleExpression.check(this.data, c, negated, this.getAnd());
    }
}

