/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.LiteralList;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleLiteral;
import ch.njol.skript.util.Utils;
import ch.njol.util.Checker;
import ch.njol.util.Kleenean;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.bukkit.event.Event;

public class ExpressionList<T>
implements Expression<T> {
    private static final long serialVersionUID = -9121024064780836522L;
    protected final Expression<? extends T>[] expressions;
    protected final boolean and;
    private final boolean single;
    private final Class<T> returnType;
    private ExpressionList<?> source;

    public ExpressionList(Expression<? extends T>[] expressions, boolean and) {
        this(expressions, and, null);
    }

    protected ExpressionList(Expression<? extends T>[] expressions, boolean and, ExpressionList<?> source) {
        assert (expressions != null && expressions.length > 1);
        this.expressions = expressions;
        this.and = and;
        Class[] cs = new Class[expressions.length];
        int i = 0;
        while (i < cs.length) {
            cs[i] = expressions[i].getReturnType();
            ++i;
        }
        Class<?> returnType = Utils.getSuperType(cs);
        this.returnType = returnType;
        if (and) {
            this.single = false;
        } else {
            boolean single = true;
            Expression<? extends T>[] expressionArray = expressions;
            int n = expressions.length;
            int n2 = 0;
            while (n2 < n) {
                Expression<T> e = expressionArray[n2];
                if (!e.isSingle()) {
                    single = false;
                    break;
                }
                ++n2;
            }
            this.single = single;
        }
        this.source = source;
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T getSingle(Event e) {
        if (!this.single) {
            throw new UnsupportedOperationException();
        }
        int[] nArray = Utils.permutation(this.expressions.length);
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            T t = this.expressions[i].getSingle(e);
            if (t != null) {
                return t;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public T[] getArray(Event e) {
        if (this.and) {
            ArrayList<T> r = new ArrayList<T>();
            Expression<? extends T>[] expressionArray = this.expressions;
            int n = this.expressions.length;
            int n2 = 0;
            while (n2 < n) {
                Expression<T> expr = expressionArray[n2];
                r.addAll(Arrays.asList(expr.getArray(e)));
                ++n2;
            }
            return r.toArray((Object[])Array.newInstance(this.returnType, r.size()));
        }
        int[] nArray = Utils.permutation(this.expressions.length);
        int n = nArray.length;
        int n3 = 0;
        while (n3 < n) {
            int i = nArray[n3];
            T[] t = this.expressions[i].getArray(e);
            if (t.length > 0) {
                return t;
            }
            ++n3;
        }
        return null;
    }

    @Override
    public T[] getAll(Event e) {
        ArrayList<T> r = new ArrayList<T>();
        Expression<? extends T>[] expressionArray = this.expressions;
        int n = this.expressions.length;
        int n2 = 0;
        while (n2 < n) {
            Expression<T> expr = expressionArray[n2];
            r.addAll(Arrays.asList(expr.getAll(e)));
            ++n2;
        }
        return r.toArray((Object[])Array.newInstance(this.returnType, r.size()));
    }

    @Override
    public Iterator<? extends T> iterator(final Event e) {
        if (!this.and) {
            int[] nArray = Utils.permutation(this.expressions.length);
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                Iterator<T> t = this.expressions[i].iterator(e);
                if (t.hasNext()) {
                    return t;
                }
                ++n2;
            }
            return null;
        }
        return new Iterator<T>(){
            private int i = 0;
            private Iterator<? extends T> current;
            {
                this.current = ExpressionList.this.expressions[0].iterator(event);
            }

            @Override
            public boolean hasNext() {
                while (this.i + 1 < ExpressionList.this.expressions.length && !this.current.hasNext()) {
                    this.current = ExpressionList.this.expressions[++this.i].iterator(e);
                }
                return this.current.hasNext();
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.current.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public boolean isSingle() {
        return this.single;
    }

    @Override
    public boolean check(Event e, Checker<? super T> c, boolean negated) {
        Expression<? extends T>[] expressionArray = this.expressions;
        int n = this.expressions.length;
        int n2 = 0;
        while (n2 < n) {
            Expression<? super T> expr = expressionArray[n2];
            Boolean b = expr.check(e, c, negated);
            if (this.and && !b.booleanValue()) {
                return false;
            }
            if (!this.and && b.booleanValue()) {
                return true;
            }
            ++n2;
        }
        return this.and;
    }

    @Override
    public boolean check(Event e, Checker<? super T> c) {
        Expression<? extends T>[] expressionArray = this.expressions;
        int n = this.expressions.length;
        int n2 = 0;
        while (n2 < n) {
            Expression<? super T> expr = expressionArray[n2];
            Boolean b = expr.check(e, c);
            if (this.and && !b.booleanValue()) {
                return false;
            }
            if (!this.and && b.booleanValue()) {
                return true;
            }
            ++n2;
        }
        return this.and;
    }

    @Override
    public <R> Expression<? extends R> getConvertedExpression(Class<R> to) {
        Expression[] exprs = new Expression[this.expressions.length];
        int i = 0;
        while (i < exprs.length) {
            exprs[i] = this.expressions[i].getConvertedExpression(to);
            if (exprs[i] == null) {
                return null;
            }
            ++i;
        }
        return new ExpressionList<T>(exprs, this.and, this);
    }

    @Override
    public Class<T> getReturnType() {
        return this.returnType;
    }

    @Override
    public boolean getAnd() {
        return this.and;
    }

    @Override
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        return null;
    }

    @Override
    public void change(Event e, Object delta, Changer.ChangeMode mode) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean setTime(int time) {
        return false;
    }

    @Override
    public int getTime() {
        return 0;
    }

    @Override
    public boolean isDefault() {
        return false;
    }

    @Override
    public boolean isLoopOf(String s) {
        Expression<? extends T>[] expressionArray = this.expressions;
        int n = this.expressions.length;
        int n2 = 0;
        while (n2 < n) {
            Expression<T> e = expressionArray[n2];
            if (e.isLoopOf(s)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public Expression<?> getSource() {
        return this.source == null ? this : this.source;
    }

    @Override
    public String toString(Event e, boolean debug) {
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (i < this.expressions.length) {
            if (i != 0) {
                if (i == this.expressions.length - 1) {
                    b.append(this.and ? " and " : " or ");
                } else {
                    b.append(", ");
                }
            }
            b.append(this.expressions[i].toString(e, debug));
            ++i;
        }
        return b.toString();
    }

    @Override
    public String toString() {
        return this.toString(null, false);
    }

    public Expression<? extends T>[] getExpressions() {
        return this.expressions;
    }

    @Override
    public Expression<T> simplify() {
        boolean isLiteralList = true;
        boolean isSimpleList = true;
        int i = 0;
        while (i < this.expressions.length) {
            this.expressions[i] = this.expressions[i].simplify();
            isLiteralList &= this.expressions[i] instanceof Literal;
            isSimpleList &= this.expressions[i].isSingle();
            ++i;
        }
        if (isLiteralList && isSimpleList) {
            Object[] values = (Object[])Array.newInstance(this.returnType, this.expressions.length);
            int i2 = 0;
            while (i2 < values.length) {
                values[i2] = ((Literal)this.expressions[i2]).getSingle();
                ++i2;
            }
            return new SimpleLiteral<Object>(values, this.returnType, this.and);
        }
        if (isLiteralList) {
            return new LiteralList((Literal[])Arrays.copyOf(this.expressions, this.expressions.length, Literal[].class), this.and);
        }
        return this;
    }
}

