/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.expressions.base.WrapperExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;

public class ExprTimeState
extends WrapperExpression<Object> {
    private static final long serialVersionUID = 7845622836544154737L;

    static {
        Skript.registerExpression(ExprTimeState.class, Object.class, ExpressionType.PROPERTY, "(former|past) [state] [of] %object%", "%object% before [the event]", "(future|to-be) [state] [of] %object%", "%object%(-to-be| after[(wards| the event)])");
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        Expression<?> expr = vars[0];
        if (expr instanceof Literal) {
            return false;
        }
        if (isDelayed == Kleenean.TRUE) {
            Skript.error("Cannot use time states after the event has already passed", ErrorQuality.SEMANTIC_ERROR);
            return false;
        }
        if (!expr.setTime(matchedPattern >= 2 ? 1 : -1)) {
            Skript.error(expr + " does not have a " + (matchedPattern >= 2 ? "future" : "past") + " state", ErrorQuality.SEMANTIC_ERROR);
            return false;
        }
        this.setExpr(expr);
        return true;
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "the " + (this.getTime() == -1 ? "past" : "future") + " state of " + this.getExpr().toString(e, debug);
    }
}

